"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeSliderEmbeddableFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/presentation-util-plugin/public");
var _time_slider_persistable_state = require("../../../common/time_slider/time_slider_persistable_state");
var _ = require("../..");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
class TimeSliderEmbeddableFactory {
  constructor() {
    (0, _defineProperty2.default)(this, "type", _.TIME_SLIDER_CONTROL);
    (0, _defineProperty2.default)(this, "isFieldCompatible", () => false);
    (0, _defineProperty2.default)(this, "isEditable", () => Promise.resolve(false));
    (0, _defineProperty2.default)(this, "canCreateNew", () => false);
    (0, _defineProperty2.default)(this, "getDisplayName", () => _i18n.i18n.translate('controls.timeSlider.displayName', {
      defaultMessage: 'Time slider'
    }));
    (0, _defineProperty2.default)(this, "getIconType", () => 'clock');
    (0, _defineProperty2.default)(this, "getDescription", () => _i18n.i18n.translate('controls.timeSlider.description', {
      defaultMessage: 'Add a slider for selecting a time range'
    }));
    (0, _defineProperty2.default)(this, "inject", (0, _time_slider_persistable_state.createTimeSliderInject)());
    (0, _defineProperty2.default)(this, "extract", (0, _time_slider_persistable_state.createTimeSliderExtract)());
  }
  async create(initialInput, parent) {
    const reduxEmbeddablePackage = await (0, _public.lazyLoadReduxToolsPackage)();
    const {
      TimeSliderControlEmbeddable
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./time_slider_embeddable')));
    return Promise.resolve(new TimeSliderControlEmbeddable(reduxEmbeddablePackage, initialInput, {}, parent));
  }
}
exports.TimeSliderEmbeddableFactory = TimeSliderEmbeddableFactory;