"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeSliderPrepend = void 0;
var _i18n = require("@kbn/i18n");
var _operators = require("rxjs/operators");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _time_slider_embeddable = require("../embeddable/time_slider_embeddable");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const TimeSliderPrepend = props => {
  const timeSlider = (0, _time_slider_embeddable.useTimeSlider)();
  const [isPaused, setIsPaused] = (0, _react.useState)(true);
  const [timeoutId, setTimeoutId] = (0, _react.useState)(undefined);
  const [subscription, setSubscription] = (0, _react.useState)(undefined);
  const playNextFrame = () => {
    // advance to next frame
    props.onNext();
    if (props.waitForControlOutputConsumersToLoad$) {
      const nextFrameSubscription = props.waitForControlOutputConsumersToLoad$.pipe((0, _operators.first)()).subscribe(() => {
        // use timeout to display frame for small time period before moving to next frame
        const nextTimeoutId = window.setTimeout(() => {
          playNextFrame();
        }, 1750);
        setTimeoutId(nextTimeoutId);
      });
      setSubscription(nextFrameSubscription);
    }
  };
  const onPlay = () => {
    timeSlider.dispatch.setIsOpen({
      isOpen: true
    });
    setIsPaused(false);
    playNextFrame();
  };
  const onPause = () => {
    timeSlider.dispatch.setIsOpen({
      isOpen: true
    });
    setIsPaused(true);
    if (subscription) {
      subscription.unsubscribe();
      setSubscription(undefined);
    }
    if (timeoutId) {
      clearTimeout(timeoutId);
      setTimeoutId(undefined);
    }
  };
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: () => {
      onPause();
      props.onPrevious();
    },
    iconType: "framePrevious",
    color: "text",
    "aria-label": _i18n.i18n.translate('controls.timeSlider.previousLabel', {
      defaultMessage: 'Previous time window'
    }),
    "data-test-subj": "timeSlider-previousTimeWindow"
  }), props.waitForControlOutputConsumersToLoad$ === undefined ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    className: "timeSlider-playToggle",
    onClick: isPaused ? onPlay : onPause,
    iconType: isPaused ? 'playFilled' : 'pause',
    size: "s",
    display: "fill",
    "aria-label": isPaused ? _i18n.i18n.translate('controls.timeSlider.playLabel', {
      defaultMessage: 'Play'
    }) : _i18n.i18n.translate('controls.timeSlider.pauseLabel', {
      defaultMessage: 'Pause'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: () => {
      onPause();
      props.onNext();
    },
    iconType: "frameNext",
    color: "text",
    "aria-label": _i18n.i18n.translate('controls.timeSlider.nextLabel', {
      defaultMessage: 'Next time window'
    }),
    "data-test-subj": "timeSlider-nextTimeWindow"
  }));
};
exports.TimeSliderPrepend = TimeSliderPrepend;