"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClearControlAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/ui-actions-plugin/public");
var _ = require(".");
var _control_group_strings = require("../control_group_strings");
var _types = require("../../types");
var _control_group_helpers = require("../embeddable/control_group_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class ClearControlAction {
  constructor() {
    (0, _defineProperty2.default)(this, "type", _.ACTION_CLEAR_CONTROL);
    (0, _defineProperty2.default)(this, "id", _.ACTION_CLEAR_CONTROL);
    (0, _defineProperty2.default)(this, "order", 1);
    (0, _defineProperty2.default)(this, "MenuItem", ({
      context
    }) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: this.getDisplayName(context)
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "data-test-subj": `control-action-${context.embeddable.id}-erase`,
        "aria-label": this.getDisplayName(context),
        iconType: this.getIconType(context),
        onClick: event => {
          event.target.blur();
          this.execute(context);
        },
        color: "text"
      }));
    });
  }
  getDisplayName({
    embeddable
  }) {
    if (!embeddable.parent || !(0, _control_group_helpers.isControlGroup)(embeddable.parent)) {
      throw new _public2.IncompatibleActionError();
    }
    return _control_group_strings.ControlGroupStrings.floatingActions.getClearButtonTitle();
  }
  getIconType({
    embeddable
  }) {
    if (!embeddable.parent || !(0, _control_group_helpers.isControlGroup)(embeddable.parent)) {
      throw new _public2.IncompatibleActionError();
    }
    return 'eraser';
  }
  async isCompatible({
    embeddable
  }) {
    if ((0, _public.isErrorEmbeddable)(embeddable)) return false;
    const controlGroup = embeddable.parent;
    return Boolean(controlGroup && (0, _control_group_helpers.isControlGroup)(controlGroup)) && (0, _types.isClearableControl)(embeddable);
  }
  async execute({
    embeddable
  }) {
    if (!embeddable.parent || !(0, _control_group_helpers.isControlGroup)(embeddable.parent) || !(0, _types.isClearableControl)(embeddable)) {
      throw new _public2.IncompatibleActionError();
    }
    embeddable.clearSelections();
  }
}
exports.ClearControlAction = ClearControlAction;