"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContentRegistry = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _utils = require("@kbn/object-versioning/lib/utils");
var _content_type = require("./content_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class ContentRegistry {
  constructor(eventBus) {
    (0, _defineProperty2.default)(this, "types", new Map());
    this.eventBus = eventBus;
  }

  /**
   * Register a new content in the registry.
   *
   * @param contentType The content type to register
   * @param config The content configuration
   */
  register(definition) {
    var _definition$version;
    if (this.types.has(definition.id)) {
      throw new Error(`Content [${definition.id}] is already registered`);
    }
    const {
      result,
      value
    } = (0, _utils.validateVersion)((_definition$version = definition.version) === null || _definition$version === void 0 ? void 0 : _definition$version.latest);
    if (!result) {
      var _definition$version2;
      throw new Error(`Invalid version [${(_definition$version2 = definition.version) === null || _definition$version2 === void 0 ? void 0 : _definition$version2.latest}]. Must be an integer.`);
    }
    if (value < 1) {
      throw new Error(`Version must be >= 1`);
    }
    const contentType = new _content_type.ContentType({
      ...definition,
      version: {
        ...definition.version,
        latest: value
      }
    }, this.eventBus);
    this.types.set(contentType.id, contentType);
  }
  getContentType(id) {
    const contentType = this.types.get(id);
    if (!contentType) {
      throw new Error(`Content [${id}] is not registered.`);
    }
    return contentType;
  }

  /** Get the definition for a specific content type */
  getDefinition(id) {
    return this.getContentType(id).definition;
  }

  /** Get the crud instance of a content type */
  getCrud(id) {
    return this.getContentType(id).crud;
  }

  /** Helper to validate if a content type has been registered */
  isContentRegistered(id) {
    return this.types.has(id);
  }
}
exports.ContentRegistry = ContentRegistry;