"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataInit = void 0;
var _react = require("react");
var _data_migration = require("./data_migration");
var _contexts = require("../../contexts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const useDataInit = () => {
  const [error, setError] = (0, _react.useState)(null);
  const [done, setDone] = (0, _react.useState)(false);
  const [retryToken, setRetryToken] = (0, _react.useState)({});
  const retry = (0, _react.useCallback)(() => {
    setRetryToken({});
    setDone(false);
    setError(null);
  }, []);
  const {
    services: {
      objectStorageClient,
      history
    }
  } = (0, _contexts.useServicesContext)();
  const dispatch = (0, _contexts.useEditorActionContext)();
  (0, _react.useEffect)(() => {
    const load = async () => {
      try {
        await (0, _data_migration.migrateToTextObjects)({
          history,
          objectStorageClient
        });
        const results = await objectStorageClient.text.findAll();
        if (!results.length) {
          const newObject = await objectStorageClient.text.create({
            createdAt: Date.now(),
            updatedAt: Date.now(),
            text: ''
          });
          dispatch({
            type: 'setCurrentTextObject',
            payload: newObject
          });
        } else {
          dispatch({
            type: 'setCurrentTextObject',
            // For backwards compatibility, we sort here according to date created to
            // always take the first item created.
            payload: results.sort((a, b) => a.createdAt - b.createdAt)[0]
          });
        }
      } catch (e) {
        setError(e);
      } finally {
        setDone(true);
      }
    };
    load();
  }, [dispatch, objectStorageClient, history, retryToken]);
  return {
    error,
    done,
    retry
  };
};
exports.useDataInit = useDataInit;