"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Editor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _components = require("../../components");
var _ = require("..");
var _console_editor = require("./legacy/console_editor");
var _services = require("../../../services");
var _contexts = require("../../contexts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const INITIAL_PANEL_WIDTH = 50;
const PANEL_MIN_WIDTH = '100px';
const Editor = /*#__PURE__*/(0, _react.memo)(({
  loading,
  setEditorInstance
}) => {
  const {
    services: {
      storage
    }
  } = (0, _contexts.useServicesContext)();
  const {
    currentTextObject
  } = (0, _contexts.useEditorReadContext)();
  const {
    requestInFlight
  } = (0, _contexts.useRequestReadContext)();
  const [fetchingMappings, setFetchingMappings] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    const subscription = (0, _services.getAutocompleteInfo)().mapping.isLoading$.subscribe(setFetchingMappings);
    return () => {
      subscription.unsubscribe();
    };
  }, []);
  const [firstPanelWidth, secondPanelWidth] = storage.get(_services.StorageKeys.WIDTH, [INITIAL_PANEL_WIDTH, INITIAL_PANEL_WIDTH]);

  /* eslint-disable-next-line react-hooks/exhaustive-deps */
  const onPanelWidthChange = (0, _react.useCallback)((0, _lodash.debounce)(widths => {
    storage.set(_services.StorageKeys.WIDTH, widths);
  }, 300), []);
  if (!currentTextObject) return null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, requestInFlight || fetchingMappings ? /*#__PURE__*/_react.default.createElement("div", {
    className: "conApp__requestProgressBarContainer"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    position: "absolute"
  })) : null, /*#__PURE__*/_react.default.createElement(_.PanelsContainer, {
    onPanelWidthChange: onPanelWidthChange,
    resizerClassName: "conApp__resizer"
  }, /*#__PURE__*/_react.default.createElement(_.Panel, {
    style: {
      height: '100%',
      position: 'relative',
      minWidth: PANEL_MIN_WIDTH
    },
    initialWidth: firstPanelWidth
  }, loading ? /*#__PURE__*/_react.default.createElement(_components.EditorContentSpinner, null) : /*#__PURE__*/_react.default.createElement(_console_editor.Editor, {
    initialTextValue: currentTextObject.text,
    setEditorInstance: setEditorInstance
  })), /*#__PURE__*/_react.default.createElement(_.Panel, {
    style: {
      height: '100%',
      position: 'relative',
      minWidth: PANEL_MIN_WIDTH
    },
    initialWidth: secondPanelWidth
  }, loading ? /*#__PURE__*/_react.default.createElement(_components.EditorContentSpinner, null) : /*#__PURE__*/_react.default.createElement(_console_editor.EditorOutput, null))));
});
exports.Editor = Editor;