"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WelcomePanel = WelcomePanel;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _editor_example = _interopRequireDefault(require("./editor_example"));
var examples = _interopRequireWildcard(require("../../../common/constants/welcome_panel"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function WelcomePanel(props) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: props.onDismiss,
    "data-test-subj": "welcomePanel",
    size: "m",
    maxWidth: 0,
    ownFocus: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.welcomePage.pageTitle",
    defaultMessage: "Send requests with Console"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.welcomePage.quickIntroDescription",
    defaultMessage: "Console understands commands in a cURL-like syntax. Here is a request to the Elasticsearch _search API."
  })), /*#__PURE__*/_react.default.createElement(_editor_example.default, {
    panel: "welcome-example-1"
  }), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.welcomePage.kibanaAPIsDescription",
    defaultMessage: "To send a request to a Kibana API, prefix the path with {kibanaApiPrefix}.",
    values: {
      kibanaApiPrefix: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "kbn:")
    }
  })), /*#__PURE__*/_react.default.createElement(_editor_example.default, {
    panel: "welcome-example-2",
    example: examples.kibanaApiExample,
    linesOfExampleCode: 2
  }), /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.welcomePage.sendMultipleRequestsTitle",
    defaultMessage: "Send multiple requests"
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.welcomePage.sendMultipleRequestsDescription",
    defaultMessage: "Select multiple requests and send them together. You'll get responses to all your requests, regardless of whether they succeed or fail."
  })), /*#__PURE__*/_react.default.createElement(_editor_example.default, {
    panel: "welcome-example-3",
    example: examples.multipleRequestsExample,
    linesOfExampleCode: 22,
    mode: "output"
  }), /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.welcomePage.addCommentsTitle",
    defaultMessage: "Add comments in request bodies"
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.welcomePage.addCommentsDescription",
    defaultMessage: "To add a single-line comment, use {hash} or {doubleSlash}. For a multiline comment, mark the beginning with {slashAsterisk} and the end with {asteriskSlash}.",
    values: {
      hash: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "#"),
      doubleSlash: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "//"),
      slashAsterisk: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "/*"),
      asteriskSlash: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "*/")
    }
  })), /*#__PURE__*/_react.default.createElement(_editor_example.default, {
    panel: "welcome-example-4",
    example: examples.commentsExample,
    linesOfExampleCode: 14
  }), /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.welcomePage.useVariablesTitle",
    defaultMessage: "Reuse values with variables"
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.welcomePage.useVariablesDescription",
    defaultMessage: "Define variables in Console, and then use them in your requests in the form of {variableName}.",
    values: {
      // use html tags to render the curly braces
      variableName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "${variableName}")
    }
  })), /*#__PURE__*/_react.default.createElement("ol", null, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.welcomePage.useVariables.step1",
    defaultMessage: "Click {variableText}, and then enter the variable name and value.",
    values: {
      variableText: /*#__PURE__*/_react.default.createElement("strong", null, "Variables")
    }
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.welcomePage.useVariables.step2",
    defaultMessage: "Refer to variables in the paths and bodies of your requests as many times as you like."
  }))), /*#__PURE__*/_react.default.createElement(_editor_example.default, {
    panel: "welcome-example-5",
    example: examples.variablesExample,
    linesOfExampleCode: 9
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    fullWidth: false,
    "data-test-subj": "help-close-button",
    onClick: props.onDismiss
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.welcomePage.closeButtonLabel",
    defaultMessage: "Dismiss"
  }))));
}