"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorRangeAutoDetectButton = ColorRangeAutoDetectButton;
exports.ColorRangeDeleteButton = ColorRangeDeleteButton;
exports.ColorRangeEditButton = ColorRangeEditButton;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _utils = require("./utils");
var _tooltip_wrapper = require("../tooltip_wrapper");
var _color_ranges_context = require("./color_ranges_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const switchContinuity = (isLast, continuity) => {
  switch (continuity) {
    case 'none':
      return isLast ? 'above' : 'below';
    case 'above':
      return isLast ? 'none' : 'all';
    case 'below':
      return isLast ? 'all' : 'none';
    case 'all':
      return isLast ? 'below' : 'above';
  }
};
function ColorRangeDeleteButton({
  index,
  dispatch
}) {
  const {
    dataBounds,
    palettes
  } = (0, _react.useContext)(_color_ranges_context.ColorRangesContext);
  const onExecuteAction = (0, _react.useCallback)(() => {
    dispatch({
      type: 'deleteColorRange',
      payload: {
        index,
        dataBounds,
        palettes
      }
    });
  }, [dispatch, index, dataBounds, palettes]);
  const title = _i18n.i18n.translate('coloring.dynamicColoring.customPalette.deleteButtonAriaLabel', {
    defaultMessage: 'Delete'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "trash",
    color: "danger",
    "aria-label": title,
    title: title,
    onClick: onExecuteAction,
    "data-test-subj": `lnsPalettePanel_dynamicColoring_removeColorRange_${index}`
  });
}
function ColorRangeEditButton({
  index,
  continuity,
  dispatch,
  accessor
}) {
  const {
    dataBounds,
    palettes,
    disableSwitchingContinuity
  } = (0, _react.useContext)(_color_ranges_context.ColorRangesContext);
  const isLast = (0, _utils.isLastItem)(accessor);
  const onExecuteAction = (0, _react.useCallback)(() => {
    const newContinuity = switchContinuity(isLast, continuity);
    dispatch({
      type: 'updateContinuity',
      payload: {
        isLast,
        continuity: newContinuity,
        dataBounds,
        palettes
      }
    });
  }, [isLast, dispatch, continuity, dataBounds, palettes]);
  let tooltipContent = isLast ? _i18n.i18n.translate('coloring.dynamicColoring.customPalette.setCustomMinValue', {
    defaultMessage: `Set custom maximum value`
  }) : _i18n.i18n.translate('coloring.dynamicColoring.customPalette.setCustomMaxValue', {
    defaultMessage: `Set custom minimum value`
  });
  if (disableSwitchingContinuity) {
    tooltipContent = _i18n.i18n.translate('coloring.dynamicColoring.customPalette.disallowedEditMinMaxValues', {
      defaultMessage: `You cannot set custom value for current configuration`
    });
  }
  return /*#__PURE__*/_react.default.createElement(_tooltip_wrapper.TooltipWrapper, {
    tooltipContent: tooltipContent,
    condition: true,
    position: "top",
    delay: "regular"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "pencil",
    "aria-label": tooltipContent,
    disabled: disableSwitchingContinuity,
    onClick: onExecuteAction,
    "data-test-subj": `lnsPalettePanel_dynamicColoring_editValue_${index}`
  }));
}
function ColorRangeAutoDetectButton({
  continuity,
  dispatch,
  accessor,
  tooltipContent,
  iconFactory
}) {
  const {
    dataBounds,
    palettes
  } = (0, _react.useContext)(_color_ranges_context.ColorRangesContext);
  const isLast = (0, _utils.isLastItem)(accessor);
  const onExecuteAction = (0, _react.useCallback)(() => {
    const newContinuity = switchContinuity(isLast, continuity);
    dispatch({
      type: 'updateContinuity',
      payload: {
        isLast,
        continuity: newContinuity,
        dataBounds,
        palettes
      }
    });
  }, [continuity, dataBounds, dispatch, isLast, palettes]);
  return /*#__PURE__*/_react.default.createElement(_tooltip_wrapper.TooltipWrapper, {
    tooltipContent: tooltipContent,
    condition: true,
    position: "top",
    delay: "regular"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: iconFactory,
    "aria-label": tooltipContent,
    onClick: onExecuteAction,
    "data-test-subj": `lnsPalettePanel_dynamicColoring_autoDetect_${isLast ? 'maximum' : 'minimum'}`
  }));
}