"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.selectColorMode = selectColorMode;
exports.selectColorPickerVisibility = selectColorPickerVisibility;
exports.selectIsAutoAssignmentMode = selectIsAutoAssignmentMode;
exports.selectPalette = selectPalette;
exports.selectSpecialAssignments = selectSpecialAssignments;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function selectPalette(getPaletteFn) {
  return state => getPaletteFn(state.colorMapping.paletteId);
}
function selectColorMode(state) {
  return state.colorMapping.colorMode;
}
function selectSpecialAssignments(state) {
  return state.colorMapping.specialAssignments;
}
function selectIsAutoAssignmentMode(state) {
  return state.colorMapping.assignmentMode === 'auto';
}
function selectColorPickerVisibility(state) {
  return state.ui.colorPicker;
}