"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticBrandPalette = exports.ELASTIC_BRAND_PALETTE_COLORS = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ELASTIC_BRAND_PALETTE_COLORS = ['#20377d', '#7de2d1', '#ff957d', '#f04e98', '#0077cc', '#fec514'];
exports.ELASTIC_BRAND_PALETTE_COLORS = ELASTIC_BRAND_PALETTE_COLORS;
const ElasticBrandPalette = {
  id: 'elastic_brand_2023',
  name: 'Elastic Brand',
  colorCount: ELASTIC_BRAND_PALETTE_COLORS.length,
  type: 'categorical',
  getColor(valueInRange) {
    return ELASTIC_BRAND_PALETTE_COLORS[valueInRange];
  }
};
exports.ElasticBrandPalette = ElasticBrandPalette;