"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateAutoAssignmentsForCategories = generateAutoAssignmentsForCategories;
var _container = require("../components/container/container");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function generateAutoAssignmentsForCategories(data, palette, colorMode) {
  const isCategorical = colorMode.type === 'categorical';
  const maxColorAssignable = data.type === 'categories' ? data.categories.length : data.bins;
  const assignableColors = isCategorical ? Math.min(palette.colorCount, maxColorAssignable) : Math.min(_container.MAX_ASSIGNABLE_COLORS, maxColorAssignable);
  const autoRules = data.type === 'categories' ? data.categories.map(c => ({
    type: 'matchExactly',
    values: [c]
  })) : Array.from({
    length: data.bins
  }, (d, i) => {
    const step = (data.max - data.min) / data.bins;
    return {
      type: 'range',
      min: data.max - i * step - step,
      max: data.max - i * step,
      minInclusive: true,
      maxInclusive: false
    };
  });
  const assignments = autoRules.slice(0, assignableColors).map((rule, colorIndex) => {
    if (isCategorical) {
      return {
        rule,
        color: {
          type: 'categorical',
          paletteId: palette.id,
          colorIndex
        },
        touched: false
      };
    } else {
      return {
        rule,
        color: {
          type: 'gradient'
        },
        touched: false
      };
    }
  });
  return assignments;
}