"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorSwatch = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _color_picker = require("./color_picker");
var _color_handling = require("../../color/color_handling");
var _color_mapping = require("../../state/color_mapping");
var _selectors = require("../../state/selectors");
var _ui = require("../../state/ui");
var _color_math = require("../../color/color_math");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ColorSwatch = ({
  colorMode,
  assignmentColor,
  getPaletteFn,
  canPickColor,
  index,
  total,
  palette,
  onColorChange,
  swatchShape,
  isDarkMode,
  forType
}) => {
  const colorPickerState = (0, _reactRedux.useSelector)(_selectors.selectColorPickerVisibility);
  const dispatch = (0, _reactRedux.useDispatch)();
  const colorPickerVisible = colorPickerState.index === index && colorPickerState.type === forType && colorPickerState.visibile;
  const colorHex = (0, _color_handling.getAssignmentColor)(colorMode, assignmentColor, getPaletteFn, isDarkMode, index, total);
  const colorIsDark = (0, _eui.isColorDark)(...(0, _color_math.getValidColor)(colorHex).rgb());
  const euiTheme = (0, _eui.useEuiTheme)();
  return canPickColor && assignmentColor.type !== 'gradient' ? /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    panelPaddingSize: "none",
    isOpen: colorPickerVisible,
    repositionOnScroll: true,
    closePopover: () => dispatch((0, _ui.hideColorPickerVisibility)()),
    anchorPosition: "upLeft",
    button: swatchShape === 'round' ? /*#__PURE__*/_react.default.createElement("button", {
      "aria-label": _i18n.i18n.translate('coloring.colorMapping.colorPicker.pickAColorAriaLabel', {
        defaultMessage: 'Pick a color'
      }),
      "data-test-subj": `lns-colorMapping-colorSwatch-${index}`,
      onClick: () => dispatch(colorPickerVisible ? (0, _ui.hideColorPickerVisibility)() : (0, _ui.colorPickerVisibility)({
        index,
        visible: true,
        type: forType
      })),
      css: (0, _react2.css)`
              background: ${colorHex};
              width: 16px;
              height: 16px;
              border-radius: 50%;
              top: 8px;
              border: 3px solid white;
              ${(0, _eui.euiShadowSmall)(euiTheme)};
              backgroundcolor: ${colorHex};
              cursor: ${canPickColor ? 'pointer' : 'not-allowed'};
            `
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiColorPickerSwatch, {
      color: colorHex,
      "aria-label": _i18n.i18n.translate('coloring.colorMapping.colorPicker.pickAColorAriaLabel', {
        defaultMessage: 'Pick a color'
      }),
      "data-test-subj": `lns-colorMapping-colorSwatch-${index}`,
      onClick: () => dispatch(colorPickerVisible ? (0, _ui.hideColorPickerVisibility)() : (0, _ui.colorPickerVisibility)({
        index,
        visible: true,
        type: forType
      })),
      style: {
        // the color swatch can't pickup colors written in rgb/css standard
        backgroundColor: colorHex,
        cursor: canPickColor ? 'pointer' : 'not-allowed',
        width: 32,
        height: 32
      },
      css: (0, _react2.css)`
              &::after {
                content: '';
                width: 0;
                height: 0;
                border-left: 3px solid transparent;
                border-right: 3px solid transparent;
                border-top: 4px solid ${colorIsDark ? 'white' : 'black'};
                margin: 0;
                bottom: 2px;
                position: absolute;
                right: 2px;
              }
            `
    })
  }, /*#__PURE__*/_react.default.createElement(_color_picker.ColorPicker, {
    key: assignmentColor.type === 'categorical' ? `${assignmentColor.colorIndex}-${assignmentColor.paletteId}` : assignmentColor.colorCode,
    color: assignmentColor,
    palette: palette,
    getPaletteFn: getPaletteFn,
    close: () => dispatch((0, _ui.hideColorPickerVisibility)()),
    isDarkMode: isDarkMode,
    selectColor: color => {
      // dispatch update
      onColorChange(color);
    },
    deleteStep: colorMode.type === 'gradient' && total > 1 ? () => dispatch((0, _color_mapping.removeGradientColorStep)(index)) : undefined
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiColorPickerSwatch, {
    color: colorHex,
    "aria-label": _i18n.i18n.translate('coloring.colorMapping.colorPicker.newColorAriaLabel', {
      defaultMessage: 'Select a new color'
    }),
    disabled: true,
    style: {
      // the color swatch can't pickup colors written in rgb/css standard
      backgroundColor: colorHex,
      cursor: 'not-allowed',
      width: 32,
      height: 32
    }
  });
};
exports.ColorSwatch = ColorSwatch;