"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRulesCountForPolicy = exports.defineGetBenchmarksRoute = exports.PACKAGE_POLICY_SAVED_OBJECT_TYPE = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../common/constants");
var _benchmark = require("../../../common/schemas/benchmark");
var _helpers = require("../../../common/utils/helpers");
var _fleet_util = require("../../lib/fleet_util");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PACKAGE_POLICY_SAVED_OBJECT_TYPE = 'ingest-package-policies';
exports.PACKAGE_POLICY_SAVED_OBJECT_TYPE = PACKAGE_POLICY_SAVED_OBJECT_TYPE;
const getRulesCountForPolicy = async (soClient, benchmarkId) => {
  const rules = await soClient.find({
    type: _constants.CSP_RULE_TEMPLATE_SAVED_OBJECT_TYPE,
    filter: (0, _helpers.getBenchmarkFilter)(benchmarkId),
    perPage: 0
  });
  return rules.total;
};
exports.getRulesCountForPolicy = getRulesCountForPolicy;
const createBenchmarks = (soClient, agentPolicies, agentStatusByAgentPolicyId, cspPackagePolicies) => {
  const cspPackagePoliciesMap = new Map(cspPackagePolicies.map(packagePolicy => [packagePolicy.id, packagePolicy]));
  return Promise.all(agentPolicies.flatMap(agentPolicy => {
    var _agentPolicy$package_, _agentPolicy$package_2;
    const cspPackagesOnAgent = (_agentPolicy$package_ = (_agentPolicy$package_2 = agentPolicy.package_policies) === null || _agentPolicy$package_2 === void 0 ? void 0 : _agentPolicy$package_2.map(({
      id: pckPolicyId
    }) => {
      return cspPackagePoliciesMap.get(pckPolicyId);
    }).filter(_helpers.isNonNullable)) !== null && _agentPolicy$package_ !== void 0 ? _agentPolicy$package_ : [];
    const benchmarks = cspPackagesOnAgent.map(async cspPackage => {
      var _agentStatusByAgentPo;
      const benchmarkId = (0, _helpers.getBenchmarkFromPackagePolicy)(cspPackage.inputs);
      const rulesCount = await getRulesCountForPolicy(soClient, benchmarkId);
      const agentPolicyStatus = {
        id: agentPolicy.id,
        name: agentPolicy.name,
        agents: (_agentStatusByAgentPo = agentStatusByAgentPolicyId[agentPolicy.id]) === null || _agentStatusByAgentPo === void 0 ? void 0 : _agentStatusByAgentPo.total
      };
      return {
        package_policy: cspPackage,
        agent_policy: agentPolicyStatus,
        rules_count: rulesCount
      };
    });
    return benchmarks;
  }));
};
const defineGetBenchmarksRoute = router => router.versioned.get({
  access: 'internal',
  path: _constants.BENCHMARKS_ROUTE_PATH,
  options: {
    tags: ['access:cloud-security-posture-read']
  }
}).addVersion({
  version: '1',
  validate: {
    request: {
      query: _benchmark.benchmarksQueryParamsSchema
    }
  }
}, async (context, request, response) => {
  if (!(await context.fleet).authz.fleet.all) {
    return response.forbidden();
  }
  const cspContext = await context.csp;
  const excludeVulnMgmtPackages = true;
  try {
    const packagePolicies = await (0, _fleet_util.getCspPackagePolicies)(cspContext.soClient, cspContext.packagePolicyService, _constants.CLOUD_SECURITY_POSTURE_PACKAGE_NAME, request.query, _constants.POSTURE_TYPE_ALL, excludeVulnMgmtPackages);
    const agentPolicies = await (0, _fleet_util.getCspAgentPolicies)(cspContext.soClient, packagePolicies.items, cspContext.agentPolicyService);
    const agentStatusesByAgentPolicyId = await (0, _fleet_util.getAgentStatusesByAgentPolicies)(cspContext.agentService, agentPolicies, cspContext.logger);
    const benchmarks = await createBenchmarks(cspContext.soClient, agentPolicies, agentStatusesByAgentPolicyId, packagePolicies.items);
    const getBenchmarkResponse = {
      ...packagePolicies,
      items: benchmarks
    };
    return response.ok({
      body: getBenchmarkResponse
    });
  } catch (err) {
    const error = (0, _securitysolutionEsUtils.transformError)(err);
    cspContext.logger.error(`Failed to fetch benchmarks ${err}`);
    return response.customError({
      body: {
        message: error.message
      },
      statusCode: error.statusCode
    });
  }
});
exports.defineGetBenchmarksRoute = defineGetBenchmarksRoute;