"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VulnerabilityOverviewTab = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _moment = _interopRequireDefault(require("moment"));
var _react2 = _interopRequireDefault(require("react"));
var _uiTheme = require("@kbn/ui-theme");
var _i18n = require("@kbn/i18n");
var _findings_flyout = require("../../configurations/findings_flyout/findings_flyout");
var _nvd_logo_svg = require("../../../assets/icons/nvd_logo_svg");
var _vulnerability_badges = require("../../../components/vulnerability_badges");
var _get_vector_score_list = require("../utils/get_vector_score_list");
var _test_subjects = require("../test_subjects");
var _redhat_logo = _interopRequireDefault(require("../../../assets/icons/redhat_logo.svg"));
var _vulnerability_detection_rule_counter = require("./vulnerability_detection_rule_counter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const cvssVendors = {
  nvd: 'NVD',
  redhat: 'Red Hat',
  ghsa: 'GHSA'
};
const vendorIcons = {
  redhat: _redhat_logo.default,
  ghsa: 'logoGithub'
};
const CVSScore = ({
  vectorBaseScore,
  vendor
}) => {
  var _cvssVendors$vendor;
  const vendorName = (_cvssVendors$vendor = cvssVendors[vendor]) !== null && _cvssVendors$vendor !== void 0 ? _cvssVendors$vendor : _i18n.i18n.translate('xpack.csp.vulnerabilities.vulnerabilityOverviewTab.cvsScore.unknownVendorName', {
    defaultMessage: 'Unknown vendor'
  });
  const vectorScores = (0, _get_vector_score_list.getVectorScoreList)(vectorBaseScore);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    css: (0, _react.css)`
        border: 1px solid #d3dae6;
        border-radius: 6px;
        padding: ${_uiTheme.euiThemeVars.euiSizeM};
      `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react.css)`
          width: 116px;
          font-weight: 600;
          display: flex;
          flex-direction: row;
          align-items: center;
        `
  }, /*#__PURE__*/_react2.default.createElement("span", {
    css: (0, _react.css)`
            margin-right: 30px;
          `
  }, vendor === 'nvd' ? (0, _nvd_logo_svg.NvdLogo)() : /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    type: vendorIcons[vendor],
    size: "xl"
  })), /*#__PURE__*/_react2.default.createElement("span", null, vendorName)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, vectorScores.length > 0 && vectorScores.map((vectorScore, i) => /*#__PURE__*/_react2.default.createElement(VectorScore, {
    key: `${vectorScore}-${i}`,
    vectorScore: vectorScore
  }))));
};
const VectorScore = ({
  vectorScore
}) => {
  const {
    score,
    vector,
    version
  } = vectorScore;
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    css: (0, _react.css)`
          background: ${_uiTheme.euiThemeVars.euiColorLightestShade};
          padding: ${_uiTheme.euiThemeVars.euiSizeXS} ${_uiTheme.euiThemeVars.euiSizeS};
          border-radius: 6px;
        `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    css: (0, _react.css)`
              font-size: ${_uiTheme.euiThemeVars.euiFontSizeM};
              color: ${_uiTheme.euiThemeVars.euiColorFullShade};
            `
  }, vector, ' ')), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, score && /*#__PURE__*/_react2.default.createElement(_vulnerability_badges.CVSScoreBadge, {
    score: score,
    version: version
  }))));
};
const VulnerabilityOverviewTiles = ({
  vulnerabilityRecord
}) => {
  var _vulnerability$score, _vulnerability$score2, _vulnerability$data_s, _vulnerability$data_s2;
  const {
    vulnerability
  } = vulnerabilityRecord;
  const tileStyle = (0, _react.css)`
    padding: ${_uiTheme.euiThemeVars.euiFontSizeM};
    background: ${_uiTheme.euiThemeVars.euiColorLightestShade};
    border-radius: 6px;
    height: 74px;
  `;
  const tileTitleTextStyle = (0, _react.css)`
    line-height: 20px;
    margin-bottom: 6px;
  `;
  const date = (0, _moment.default)(vulnerability === null || vulnerability === void 0 ? void 0 : vulnerability.published_date).format('LL').toString();
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": _test_subjects.OVERVIEW_TAB_VULNERABILITY_FLYOUT
  }, (vulnerability === null || vulnerability === void 0 ? void 0 : (_vulnerability$score = vulnerability.score) === null || _vulnerability$score === void 0 ? void 0 : _vulnerability$score.version) && (vulnerability === null || vulnerability === void 0 ? void 0 : (_vulnerability$score2 = vulnerability.score) === null || _vulnerability$score2 === void 0 ? void 0 : _vulnerability$score2.base) && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: tileStyle
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    css: tileTitleTextStyle
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.vulnerabilities.vulnerabilityOverviewTile.cvsScore",
    defaultMessage: "CVSS"
  })), /*#__PURE__*/_react2.default.createElement("div", null, /*#__PURE__*/_react2.default.createElement(_vulnerability_badges.CVSScoreBadge, {
    version: vulnerability.score.version,
    score: vulnerability.score.base
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: tileStyle
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    css: tileTitleTextStyle
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.vulnerabilities.vulnerabilityOverviewTile.dataSource",
    defaultMessage: "Data Source"
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, {
    href: vulnerability === null || vulnerability === void 0 ? void 0 : (_vulnerability$data_s = vulnerability.data_source) === null || _vulnerability$data_s === void 0 ? void 0 : _vulnerability$data_s.URL,
    target: "_blank"
  }, vulnerability === null || vulnerability === void 0 ? void 0 : (_vulnerability$data_s2 = vulnerability.data_source) === null || _vulnerability$data_s2 === void 0 ? void 0 : _vulnerability$data_s2.ID)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: tileStyle
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    css: tileTitleTextStyle
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.vulnerabilities.vulnerabilityOverviewTile.publishedDate",
    defaultMessage: "Published Date"
  })), /*#__PURE__*/_react2.default.createElement("strong", null, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.vulnerabilities.vulnerabilityOverviewTile.publishedDateText",
    defaultMessage: "{date}",
    values: {
      date
    }
  }))));
};
const VulnerabilityOverviewTab = ({
  vulnerabilityRecord
}) => {
  var _vulnerabilityRecord$, _vulnerabilityRecord$2, _vulnerabilityRecord$3;
  const {
    vulnerability
  } = vulnerabilityRecord;
  const emptyFixesMessageState = _i18n.i18n.translate('xpack.csp.vulnerabilities.vulnerabilityOverviewTab.emptyFixesMessage', {
    defaultMessage: 'No available fixes yet.'
  });
  const fixesDisplayText = vulnerabilityRecord !== null && vulnerabilityRecord !== void 0 && (_vulnerabilityRecord$ = vulnerabilityRecord.package) !== null && _vulnerabilityRecord$ !== void 0 && _vulnerabilityRecord$.fixed_version ? `${vulnerabilityRecord === null || vulnerabilityRecord === void 0 ? void 0 : (_vulnerabilityRecord$2 = vulnerabilityRecord.package) === null || _vulnerabilityRecord$2 === void 0 ? void 0 : _vulnerabilityRecord$2.name} ${vulnerabilityRecord === null || vulnerabilityRecord === void 0 ? void 0 : (_vulnerabilityRecord$3 = vulnerabilityRecord.package) === null || _vulnerabilityRecord$3 === void 0 ? void 0 : _vulnerabilityRecord$3.fixed_version}` : emptyFixesMessageState;
  const cvssScores = vulnerability !== null && vulnerability !== void 0 && vulnerability.cvss ? Object.entries(vulnerability.cvss).map(([vendor, vectorScoreBase]) => {
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      key: `${vendor}`
    }, /*#__PURE__*/_react2.default.createElement(CVSScore, {
      vectorBaseScore: vectorScoreBase,
      vendor: vendor
    }));
  }) : [];
  const horizontalStyle = (0, _react.css)`
    margin-block: 12px;
  `;
  const flyoutSubheadingStyle = (0, _react.css)`
    font-size: ${_uiTheme.euiThemeVars.euiFontSizeM};
    line-height: 24px;
    margin-bottom: ${_uiTheme.euiThemeVars.euiSizeS};
    font-weight: 600;
  `;
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(VulnerabilityOverviewTiles, {
    vulnerabilityRecord: vulnerabilityRecord
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiHorizontalRule, {
    css: horizontalStyle
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement("h4", {
    css: flyoutSubheadingStyle
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.vulnerabilities.vulnerabilityOverviewTab.alertsTitle",
    defaultMessage: "Alerts"
  })), /*#__PURE__*/_react2.default.createElement(_vulnerability_detection_rule_counter.VulnerabilityDetectionRuleCounter, {
    vulnerability: vulnerability
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement("h4", {
    css: flyoutSubheadingStyle
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.vulnerabilities.vulnerabilityOverviewTab.descriptionTitle",
    defaultMessage: "Description"
  })), /*#__PURE__*/_react2.default.createElement(_findings_flyout.CspFlyoutMarkdown, null, (vulnerability === null || vulnerability === void 0 ? void 0 : vulnerability.description) || '')), /*#__PURE__*/_react2.default.createElement(_eui.EuiHorizontalRule, {
    css: horizontalStyle
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement("h4", {
    css: flyoutSubheadingStyle
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.vulnerabilities.vulnerabilityOverviewTab.fixes",
    defaultMessage: "Fixes"
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiText, null, fixesDisplayText)), /*#__PURE__*/_react2.default.createElement(_eui.EuiHorizontalRule, {
    css: horizontalStyle
  }), (cvssScores === null || cvssScores === void 0 ? void 0 : cvssScores.length) > 0 && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement("h4", {
    css: flyoutSubheadingStyle
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.vulnerabilities.vulnerabilityOverviewTab.vulnerabilityScores",
    defaultMessage: "Vulnerability Scores"
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l",
    css: (0, _react.css)`
              margin-top: ${_uiTheme.euiThemeVars.euiSizeS};
            `
  }, cvssScores)));
};
exports.VulnerabilityOverviewTab = VulnerabilityOverviewTab;