"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeverityMap = void 0;
var _react = _interopRequireDefault(require("react"));
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _get_vulnerability_colors = require("../../../common/utils/get_vulnerability_colors");
var _vulnerability_badges = require("../../../components/vulnerability_badges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatPercentage = percentage => {
  if (percentage === 0) {
    return '0%';
  }
  if (percentage === 100) {
    return '100%';
  }
  return `${percentage.toFixed(1)}%`;
};
const SeverityMap = ({
  severityMap,
  total
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const severityMapPallet = [];
  const severityMapTooltip = [];
  if (total > 0) {
    // Setting a minimum stop value of 8% the palette bar to avoid the color
    // palette being too small to be visible
    const minStop = Math.max(0.08 * total, 1);
    const severityLevels = ['low', 'medium', 'high', 'critical'];
    let currentStop = 0;
    severityLevels.forEach(severity => {
      if (severityMap[severity] > 0) {
        currentStop += Math.max(severityMap[severity], minStop);
        severityMapPallet.push({
          stop: currentStop,
          color: (0, _get_vulnerability_colors.getSeverityStatusColor)(severity.toUpperCase())
        });
      }
      severityMapTooltip.push({
        severity,
        count: severityMap[severity],
        percentage: severityMap[severity] / total * 100
      });
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    className: (0, _css.css)`
        width: 256px;
      `,
    anchorClassName: (0, _css.css)`
        height: ${euiTheme.size.xl};
        display: flex;
        align-items: center;
      `,
    position: "left",
    title: _i18n.i18n.translate('xpack.csp.vulnerabilitiesByResource.severityMap.tooltipTitle', {
      defaultMessage: 'Severity map'
    }),
    content: /*#__PURE__*/_react.default.createElement(TooltipBody, {
      severityMapTooltip: severityMapTooltip
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPaletteDisplay, {
    type: "fixed",
    palette: severityMapPallet,
    className: (0, _css.css)`
          width: 100%;
        `
  }));
};
exports.SeverityMap = SeverityMap;
const TooltipBody = ({
  severityMapTooltip
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, severityMapTooltip.map(severity => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    key: severity.severity,
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_vulnerability_badges.SeverityStatusBadge, {
    severity: severity.severity.toUpperCase()
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, severity.count)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "right",
    size: "s",
    className: (0, _css.css)`
                    width: ${euiTheme.size.xxxl};
                    color: ${euiTheme.colors.mediumShade};
                  `
  }, formatPercentage(severity.percentage))))))));
};