"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResourceFindings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _csp_inline_description_list = require("../../../../components/csp_inline_description_list");
var _cloud_posture_page_title = require("../../../../components/cloud_posture_page_title");
var TEST_SUBJECTS = _interopRequireWildcard(require("../../test_subjects"));
var _findings_layout = require("../../layout/findings_layout");
var _constants = require("../../../../common/navigation/constants");
var _use_resource_findings = require("./use_resource_findings");
var _use_page_slice = require("../../../../common/hooks/use_page_slice");
var _utils = require("../../utils/utils");
var _resource_findings_table = require("./resource_findings_table");
var _findings_search_bar = require("../../layout/findings_search_bar");
var _error_callout = require("../../layout/error_callout");
var _findings_distribution_bar = require("../../layout/findings_distribution_bar");
var _constants2 = require("../../../../common/constants");
var _use_cloud_posture_table = require("../../../../common/hooks/use_cloud_posture_table");
var _get_limit_properties = require("../../../../common/utils/get_limit_properties");
var _utils2 = require("../../../../common/hooks/use_cloud_posture_table/utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDefaultQuery = ({
  query,
  filters
}) => ({
  query,
  filters,
  sort: {
    field: 'result.evaluation',
    direction: 'asc'
  },
  pageIndex: 0,
  findingIndex: -1
});
const BackToResourcesButton = () => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Link, {
  to: (0, _reactRouterDom.generatePath)(_constants.findingsNavigation.findings_by_resource.path)
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  iconType: "arrowLeft",
  flush: "both"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.findings.resourceFindings.backToResourcesPageButtonLabel",
  defaultMessage: "Back to resources"
})));
const getResourceFindingSharedValues = sharedValues => [{
  title: _i18n.i18n.translate('xpack.csp.findings.resourceFindingsSharedValues.resourceTypeTitle', {
    defaultMessage: 'Resource Type'
  }),
  description: sharedValues.resourceSubType
}, {
  title: _i18n.i18n.translate('xpack.csp.findings.resourceFindingsSharedValues.resourceIdTitle', {
    defaultMessage: 'Resource ID'
  }),
  description: sharedValues.resourceId
}, {
  title: _i18n.i18n.translate('xpack.csp.findings.resourceFindingsSharedValues.clusterIdTitle', {
    defaultMessage: 'Cluster ID'
  }),
  description: sharedValues.clusterId
}, {
  title: _i18n.i18n.translate('xpack.csp.findings.resourceFindingsSharedValues.cloudAccountName', {
    defaultMessage: 'Cloud Account Name'
  }),
  description: sharedValues.cloudAccountName
}];

/**
 * @deprecated: This component is deprecated and will be removed in the next release.
 */
const ResourceFindings = ({
  dataView
}) => {
  var _resourceFindings$dat, _resourceFindings$dat2, _resourceFindings$dat3, _resourceFindings$dat4, _resourceFindings$dat5, _resourceFindings$dat6, _resourceFindings$dat7, _resourceFindings$dat8;
  const params = (0, _reactRouterDom.useParams)();
  const decodedResourceId = decodeURIComponent(params.resourceId);
  const {
    pageIndex,
    sort,
    query,
    queryError,
    pageSize,
    setTableOptions,
    urlQuery,
    setUrlQuery,
    onResetFilters
  } = (0, _use_cloud_posture_table.useCloudPostureTable)({
    dataView,
    defaultQuery: getDefaultQuery,
    paginationLocalStorageKey: _constants2.LOCAL_STORAGE_PAGE_SIZE_FINDINGS_KEY
  });

  /**
   * Page ES query result
   */
  const resourceFindings = (0, _use_resource_findings.useResourceFindings)({
    sort,
    resourceId: decodedResourceId,
    enabled: !queryError,
    query
  });
  const error = resourceFindings.error || queryError;
  const slicedPage = (0, _use_page_slice.usePageSlice)((_resourceFindings$dat = resourceFindings.data) === null || _resourceFindings$dat === void 0 ? void 0 : _resourceFindings$dat.page, urlQuery.pageIndex, pageSize);
  const {
    isLastLimitedPage,
    limitedTotalItemCount
  } = (0, _get_limit_properties.useLimitProperties)({
    total: (_resourceFindings$dat2 = resourceFindings.data) === null || _resourceFindings$dat2 === void 0 ? void 0 : _resourceFindings$dat2.total,
    pageIndex: urlQuery.pageIndex,
    pageSize
  });
  const handleDistributionClick = evaluation => {
    setUrlQuery({
      pageIndex: 0,
      filters: (0, _utils.getFilters)({
        filters: urlQuery.filters,
        dataView,
        field: 'result.evaluation',
        value: evaluation,
        negate: false
      })
    });
  };
  const flyoutFindingIndex = urlQuery === null || urlQuery === void 0 ? void 0 : urlQuery.findingIndex;
  const pagination = (0, _utils2.getPaginationTableParams)({
    pageSize,
    pageIndex,
    totalItemCount: limitedTotalItemCount
  });
  const onOpenFlyout = (0, _react.useCallback)(flyoutFinding => {
    setUrlQuery({
      findingIndex: slicedPage.findIndex(finding => finding.resource.id === (flyoutFinding === null || flyoutFinding === void 0 ? void 0 : flyoutFinding.resource.id) && finding.rule.id === (flyoutFinding === null || flyoutFinding === void 0 ? void 0 : flyoutFinding.rule.id))
    });
  }, [slicedPage, setUrlQuery]);
  const onCloseFlyout = () => setUrlQuery({
    findingIndex: -1
  });
  const onPaginateFlyout = (0, _react.useCallback)(nextFindingIndex => {
    // the index of the finding in the current page
    const newFindingIndex = nextFindingIndex % pageSize;

    // if the finding is not in the current page, we need to change the page
    const flyoutPageIndex = Math.floor(nextFindingIndex / pageSize);
    setUrlQuery({
      pageIndex: flyoutPageIndex,
      findingIndex: newFindingIndex
    });
  }, [pageSize, setUrlQuery]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": TEST_SUBJECTS.RESOURCES_FINDINGS_CONTAINER
  }, /*#__PURE__*/_react.default.createElement(_findings_search_bar.FindingsSearchBar, {
    dataView: dataView,
    setQuery: newQuery => {
      setUrlQuery({
        ...newQuery,
        pageIndex: 0
      });
    },
    loading: resourceFindings.isFetching
  }), /*#__PURE__*/_react.default.createElement(BackToResourcesButton, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_findings_layout.PageTitle, null, /*#__PURE__*/_react.default.createElement(_findings_layout.PageTitleText, {
    title: /*#__PURE__*/_react.default.createElement(_cloud_posture_page_title.CloudPosturePageTitle, {
      title: _i18n.i18n.translate('xpack.csp.findings.resourceFindings.resourceFindingsPageTitle', {
        defaultMessage: '{resourceName} {hyphen} Findings',
        values: {
          resourceName: (_resourceFindings$dat3 = resourceFindings.data) === null || _resourceFindings$dat3 === void 0 ? void 0 : _resourceFindings$dat3.resourceName,
          hyphen: (_resourceFindings$dat4 = resourceFindings.data) !== null && _resourceFindings$dat4 !== void 0 && _resourceFindings$dat4.resourceName ? '-' : ''
        }
      })
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), resourceFindings.data && /*#__PURE__*/_react.default.createElement(_csp_inline_description_list.CspInlineDescriptionList, {
    listItems: getResourceFindingSharedValues({
      resourceId: decodedResourceId,
      resourceName: ((_resourceFindings$dat5 = resourceFindings.data) === null || _resourceFindings$dat5 === void 0 ? void 0 : _resourceFindings$dat5.resourceName) || '',
      resourceSubType: ((_resourceFindings$dat6 = resourceFindings.data) === null || _resourceFindings$dat6 === void 0 ? void 0 : _resourceFindings$dat6.resourceSubType) || '',
      clusterId: ((_resourceFindings$dat7 = resourceFindings.data) === null || _resourceFindings$dat7 === void 0 ? void 0 : _resourceFindings$dat7.clusterId) || '',
      cloudAccountName: ((_resourceFindings$dat8 = resourceFindings.data) === null || _resourceFindings$dat8 === void 0 ? void 0 : _resourceFindings$dat8.cloudAccountName) || ''
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), error && /*#__PURE__*/_react.default.createElement(_error_callout.ErrorCallout, {
    error: error
  }), !error && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, resourceFindings.isSuccess && !!resourceFindings.data.page.length && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_findings_distribution_bar.FindingsDistributionBar, {
    distributionOnClick: handleDistributionClick,
    type: _i18n.i18n.translate('xpack.csp.findings.resourceFindings.tableRowTypeLabel', {
      defaultMessage: 'Findings'
    }),
    passed: resourceFindings.data.count.passed,
    failed: resourceFindings.data.count.failed
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_findings_distribution_bar.CurrentPageOfTotal, {
    pageStart: urlQuery.pageIndex * pageSize + 1,
    pageEnd: urlQuery.pageIndex * pageSize + slicedPage.length,
    total: resourceFindings.data.total,
    type: _i18n.i18n.translate('xpack.csp.findings.resourceFindings.tableRowTypeLabel', {
      defaultMessage: 'Findings'
    })
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_resource_findings_table.ResourceFindingsTable, {
    onCloseFlyout: onCloseFlyout,
    onPaginateFlyout: onPaginateFlyout,
    onOpenFlyout: onOpenFlyout,
    onResetFilters: onResetFilters,
    flyoutFindingIndex: flyoutFindingIndex,
    loading: resourceFindings.isFetching,
    items: slicedPage,
    pagination: pagination,
    sorting: {
      sort: {
        field: urlQuery.sort.field,
        direction: urlQuery.sort.direction
      }
    },
    setTableOptions: setTableOptions,
    onAddFilter: (field, value, negate) => setUrlQuery({
      pageIndex: 0,
      filters: (0, _utils.getFilters)({
        filters: urlQuery.filters,
        dataView,
        field,
        value,
        negate
      })
    })
  })), isLastLimitedPage && /*#__PURE__*/_react.default.createElement(_findings_layout.LimitedResultsBar, null));
};
exports.ResourceFindings = ResourceFindings;