"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getResourceId = exports.formatNumber = exports.findingsByResourceColumns = exports.FindingsByResourceTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _column_name_with_tooltip = require("../../../components/column_name_with_tooltip");
var _compliance_score_bar = require("../../../components/compliance_score_bar");
var TEST_SUBJECTS = _interopRequireWildcard(require("../test_subjects"));
var _constants = require("../../../common/navigation/constants");
var _findings_layout = require("../layout/findings_layout");
var _empty_state = require("../../../components/empty_state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * @deprecated: This function is deprecated and will be removed in the next release.
 * use getAbbreviatedNumber from x-pack/plugins/cloud_security_posture/public/common/utils/get_abbreviated_number.ts
 */
const formatNumber = value => value < 1000 ? value : (0, _numeral.default)(value).format('0.0a');
exports.formatNumber = formatNumber;
/**
 * @deprecated: This function is deprecated and will be removed in the next release.
 */
const getResourceId = resource => {
  const sections = resource['rule.section'] || [];
  return [resource.resource_id, ...sections].join('/');
};

/**
 * @deprecated: This component is deprecated and will be removed in the next release.
 */
exports.getResourceId = getResourceId;
const FindingsByResourceTableComponent = ({
  items,
  loading,
  pagination,
  sorting,
  setTableOptions,
  onAddFilter,
  onResetFilters
}) => {
  const getRowProps = row => ({
    'data-test-subj': TEST_SUBJECTS.getFindingsByResourceTableRowTestId(getResourceId(row))
  });
  const getNonSortableColumn = column => ({
    ...column,
    sortable: false
  });
  const columns = (0, _react.useMemo)(() => [{
    ...getNonSortableColumn(findingsByResourceColumns.resource_id),
    ['data-test-subj']: TEST_SUBJECTS.FINDINGS_BY_RESOURCE_TABLE_RESOURCE_ID_COLUMN
  }, (0, _findings_layout.createColumnWithFilters)(getNonSortableColumn(findingsByResourceColumns['resource.sub_type']), {
    onAddFilter
  }), (0, _findings_layout.createColumnWithFilters)(getNonSortableColumn(findingsByResourceColumns['resource.name']), {
    onAddFilter
  }), (0, _findings_layout.createColumnWithFilters)(getNonSortableColumn(findingsByResourceColumns['rule.benchmark.name']), {
    onAddFilter
  }), getNonSortableColumn(findingsByResourceColumns.belongs_to), findingsByResourceColumns.compliance_score], [onAddFilter]);
  if (!loading && !items.length) {
    return /*#__PURE__*/_react.default.createElement(_empty_state.EmptyState, {
      onResetFilters: onResetFilters
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": TEST_SUBJECTS.FINDINGS_BY_RESOURCE_TABLE,
    loading: loading,
    items: items,
    columns: columns,
    rowProps: getRowProps,
    pagination: pagination,
    sorting: sorting,
    onChange: setTableOptions
  });
};
const baseColumns = [{
  ..._findings_layout.baseFindingsColumns['resource.id'],
  field: 'resource_id',
  width: '15%',
  render: resourceId => {
    if (!resourceId) return;
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Link, {
      to: (0, _reactRouterDom.generatePath)(_constants.findingsNavigation.resource_findings.path, {
        resourceId: encodeURIComponent(resourceId)
      }),
      className: "eui-textTruncate",
      title: resourceId
    }, resourceId);
  }
}, _findings_layout.baseFindingsColumns['resource.sub_type'], _findings_layout.baseFindingsColumns['resource.name'], _findings_layout.baseFindingsColumns['rule.benchmark.name'], {
  field: 'rule.section',
  truncateText: true,
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.findings.findingsByResourceTable.cisSectionsColumnLabel",
    defaultMessage: "CIS Sections"
  }),
  render: sections => {
    const items = sections.join(', ');
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: items,
      anchorClassName: "eui-textTruncate"
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, items));
  }
}, {
  field: 'belongs_to',
  name: /*#__PURE__*/_react.default.createElement(_column_name_with_tooltip.ColumnNameWithTooltip, {
    columnName: _i18n.i18n.translate('xpack.csp.findings.findingsTable.findingsTableColumn.clusterIdColumnLabel', {
      defaultMessage: 'Belongs To'
    }),
    tooltipContent: _i18n.i18n.translate('xpack.csp.findings.findingsTable.findingsTableColumn.clusterIdColumnTooltipLabel', {
      defaultMessage: 'Kubernetes Cluster ID or Cloud Account Name'
    })
  }),
  truncateText: true
}, {
  field: 'compliance_score',
  width: '150px',
  truncateText: true,
  sortable: true,
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.findings.findingsByResourceTable.postureScoreColumnLabel",
    defaultMessage: "Posture Score"
  }),
  render: (complianceScore, data) => /*#__PURE__*/_react.default.createElement(_compliance_score_bar.ComplianceScoreBar, {
    totalPassed: data.findings.passed_findings,
    totalFailed: data.findings.failed_findings
  }),
  dataType: 'number'
}];
/**
 * @deprecated: This function is deprecated and will be removed in the next release.
 */
const findingsByResourceColumns = Object.fromEntries(baseColumns.map(column => [column.field, column]));

/**
 * @deprecated: This component is deprecated and will be removed in the next release.
 */
exports.findingsByResourceColumns = findingsByResourceColumns;
const FindingsByResourceTable = /*#__PURE__*/_react.default.memo(FindingsByResourceTableComponent);
exports.FindingsByResourceTable = FindingsByResourceTable;