"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BenchmarkDetailsBox = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _benchmarks_section = require("./benchmarks_section");
var _use_navigate_findings = require("../../../common/hooks/use_navigate_findings");
var _cis_benchmark_icon = require("../../../components/cis_benchmark_icon");
var _cis_logo = _interopRequireDefault(require("../../../assets/icons/cis_logo.svg"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BenchmarkDetailsBox = ({
  benchmark
}) => {
  const navToFindings = (0, _use_navigate_findings.useNavigateFindings)();
  const handleBenchmarkClick = () => {
    return navToFindings((0, _benchmarks_section.getBenchmarkIdQuery)(benchmark));
  };
  const getBenchmarkInfo = (benchmarkId, cloudAssetCount) => {
    const benchmarks = {
      cis_gcp: {
        name: _i18n.i18n.translate('xpack.csp.dashboard.benchmarkSection.benchmarkName.cisGcpBenchmarkName', {
          defaultMessage: 'CIS GCP'
        }),
        assetType: _i18n.i18n.translate('xpack.csp.dashboard.benchmarkSection.benchmarkName.cisGcpBenchmarkAssetType', {
          defaultMessage: '{count, plural, one {# Project} other {# Projects}}',
          values: {
            count: cloudAssetCount
          }
        })
      },
      cis_aws: {
        name: _i18n.i18n.translate('xpack.csp.dashboard.benchmarkSection.benchmarkName.cisAwsBenchmarkName', {
          defaultMessage: 'CIS AWS'
        }),
        assetType: _i18n.i18n.translate('xpack.csp.dashboard.benchmarkSection.benchmarkName.cisAwsBenchmarkAssetType', {
          defaultMessage: '{count, plural, one {# Account} other {# Accounts}}',
          values: {
            count: cloudAssetCount
          }
        })
      },
      cis_azure: {
        name: _i18n.i18n.translate('xpack.csp.dashboard.benchmarkSection.benchmarkName.cisAzureBenchmarkName', {
          defaultMessage: 'CIS Azure'
        }),
        assetType: _i18n.i18n.translate('xpack.csp.dashboard.benchmarkSection.benchmarkName.cisAzureBenchmarkAssetType', {
          defaultMessage: '{count, plural, one {# Subscription} other {# Subscriptions}}',
          values: {
            count: cloudAssetCount
          }
        })
      },
      cis_k8s: {
        name: _i18n.i18n.translate('xpack.csp.dashboard.benchmarkSection.benchmarkName.cisK8sBenchmarkName', {
          defaultMessage: 'CIS Kubernetes'
        }),
        assetType: _i18n.i18n.translate('xpack.csp.dashboard.benchmarkSection.benchmarkName.cisK8sBenchmarkAssetType', {
          defaultMessage: '{count, plural, one {# Cluster} other {# Clusters}}',
          values: {
            count: cloudAssetCount
          }
        })
      },
      cis_eks: {
        name: _i18n.i18n.translate('xpack.csp.dashboard.benchmarkSection.benchmarkName.cisEksBenchmarkName', {
          defaultMessage: 'CIS EKS'
        }),
        assetType: _i18n.i18n.translate('xpack.csp.dashboard.benchmarkSection.benchmarkName.cisEksBenchmarkAssetType', {
          defaultMessage: '{count, plural, one {# Cluster} other {# Clusters}}',
          values: {
            count: cloudAssetCount
          }
        })
      }
    };
    return benchmarks[benchmarkId];
  };
  const cisTooltip = _i18n.i18n.translate('xpack.csp.dashboard.benchmarkSection.benchmarkName.cisBenchmarkTooltip', {
    defaultMessage: 'Center of Internet Security'
  });
  const benchmarkInfo = getBenchmarkInfo(benchmark.meta.benchmarkId, benchmark.meta.assetCount);
  const benchmarkId = benchmark.meta.benchmarkId;
  const benchmarkVersion = benchmark.meta.benchmarkVersion;
  const benchmarkName = benchmark.meta.benchmarkName;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.dashboard.benchmarkSection.benchmarkTitleTooltip.benchmarkPrefixTitle",
      defaultMessage: "Show all findings for "
    }), /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.dashboard.benchmarkSection.benchmarkTitleTooltip.benchmarkTitle",
      defaultMessage: "{benchmark}",
      values: {
        benchmark: benchmarkName
      }
    })))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: handleBenchmarkClick,
    color: "text"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    css: {
      fontSize: 20
    }
  }, /*#__PURE__*/_react.default.createElement("h5", null, benchmarkInfo.name)))), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: handleBenchmarkClick,
    color: "text"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, benchmarkInfo.assetType))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      justifyContent: 'flex-end'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_cis_benchmark_icon.CISBenchmarkIcon, {
    type: benchmarkId,
    name: `${benchmarkName}`
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: cisTooltip
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: _cis_logo.default,
    size: "xxl"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, benchmarkVersion))));
};
exports.BenchmarkDetailsBox = BenchmarkDetailsBox;