"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTopRisks = exports.RisksTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _compliance_score_bar = require("../../../components/compliance_score_bar");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTopRisks = (groupedFindingsEvaluation, maxItems) => {
  const sorted = groupedFindingsEvaluation.slice().sort((first, second) => first.postureScore - second.postureScore);
  return sorted.slice(0, maxItems);
};
exports.getTopRisks = getTopRisks;
const RisksTable = ({
  data: cisSectionsEvaluations,
  maxItems,
  onCellClick,
  onViewAllClick,
  viewAllButtonTitle,
  compact
}) => {
  const columns = (0, _react.useMemo)(() => [{
    field: 'name',
    truncateText: true,
    name: compact ? '' : _i18n.i18n.translate('xpack.csp.dashboard.risksTable.cisSectionColumnLabel', {
      defaultMessage: 'CIS Section'
    }),
    render: name => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => onCellClick(name),
      className: "eui-textTruncate",
      color: "text"
    }, name)
  }, {
    field: 'postureScore',
    width: '115px',
    name: compact ? '' : _i18n.i18n.translate('xpack.csp.dashboard.risksTable.complianceColumnLabel', {
      defaultMessage: 'Compliance'
    }),
    render: (postureScore, data) => /*#__PURE__*/_react.default.createElement(_compliance_score_bar.ComplianceScoreBar, {
      totalPassed: data.totalPassed,
      totalFailed: data.totalFailed
    })
  }], [compact, onCellClick]);
  const sortedByComplianceScore = getTopRisks(cisSectionsEvaluations, maxItems);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    justifyContent: "spaceBetween",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    className: "risk-table",
    css: compact ? (0, _react2.css)`
                  thead {
                    .euiTableCellContent {
                      padding: 0;
                    }
                  }
                  .euiTable .euiTableRow .euiTableRowCell {
                    border-top: none;
                  }
                ` : undefined,
    items: sortedByComplianceScore,
    columns: columns
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onViewAllClick,
    iconType: "search"
  }, viewAllButtonTitle))));
};
exports.RisksTable = RisksTable;