"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.showSuccessToast = exports.TakeAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _reactQuery = require("@tanstack/react-query");
var _test_subjects = require("./test_subjects");
var _use_kibana = require("../common/hooks/use_kibana");
var _constants = require("../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RULE_PAGE_PATH = '/app/security/rules/id/';
const showSuccessToast = (notifications, http, ruleResponse) => {
  return notifications.toasts.addSuccess({
    toastLifeTimeMs: 10000,
    color: 'success',
    iconType: '',
    'data-test-subj': 'csp:toast-success',
    text: (0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m"
    }, /*#__PURE__*/_react.default.createElement("strong", {
      "data-test-subj": "csp:toast-success-title"
    }, ruleResponse.name), ` `, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.flyout.ruleCreatedToastTitle",
      defaultMessage: "detection rule was created."
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.flyout.ruleCreatedToast",
      defaultMessage: "Add rule actions to get notified when alerts are generated."
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "csp:toast-success-link",
      size: "s",
      href: http.basePath.prepend(RULE_PAGE_PATH + ruleResponse.id)
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.flyout.ruleCreatedToastViewRuleButton",
      defaultMessage: "View rule"
    }))))))
  });
};

/*
 * This component is used to create a detection rule from Flyout.
 * It accepts a createRuleFn parameter which is used to create a rule in a generic way.
 */
exports.showSuccessToast = showSuccessToast;
const TakeAction = ({
  createRuleFn
}) => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  const [isPopoverOpen, setPopoverOpen] = (0, _react.useState)(false);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const closePopover = () => {
    setPopoverOpen(false);
  };
  const smallContextMenuPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'smallContextMenuPopover'
  });
  const {
    http,
    notifications
  } = (0, _use_kibana.useKibana)().services;
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isLoading: isLoading,
    fill: true,
    iconType: "arrowDown",
    iconSide: "right",
    onClick: () => setPopoverOpen(!isPopoverOpen)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.flyout.takeActionButton",
    defaultMessage: "Take action"
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: smallContextMenuPopoverId,
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    "data-test-subj": _test_subjects.TAKE_ACTION_SUBJ
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "createRule",
      onClick: async () => {
        closePopover();
        setIsLoading(true);
        const ruleResponse = await createRuleFn(http);
        setIsLoading(false);
        showSuccessToast(notifications, http, ruleResponse);
        // Triggering a refetch of rules and alerts to update the UI
        queryClient.invalidateQueries([_constants.DETECTION_ENGINE_RULES_KEY]);
        queryClient.invalidateQueries([_constants.DETECTION_ENGINE_ALERTS_KEY]);
      },
      "data-test-subj": _test_subjects.CREATE_RULE_ACTION_SUBJ
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Create a detection rule",
      id: "xpack.csp.createDetectionRuleButton"
    }))]
  }));
};
exports.TakeAction = TakeAction;