"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoVulnerabilitiesStates = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _constants = require("../../common/constants");
var _full_size_centered_page = require("./full_size_centered_page");
var _cloud_posture_page = require("./cloud_posture_page");
var _use_setup_status_api = require("../common/api/use_setup_status_api");
var _test_subjects = require("./test_subjects");
var _no_data_illustration = _interopRequireDefault(require("../assets/illustrations/no_data_illustration.svg"));
var _use_csp_integration_link = require("../common/navigation/use_csp_integration_link");
var _use_navigate_to_cis_integration_policies = require("../common/navigation/use_navigate_to_cis_integration_policies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const REFETCH_INTERVAL_MS = 20000;
const ScanningVulnerabilitiesEmptyPrompt = () => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  "data-test-subj": _test_subjects.NO_VULNERABILITIES_STATUS_TEST_SUBJ.SCANNING_VULNERABILITIES,
  color: "plain",
  icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
    logo: "logoSecurity",
    size: "xl"
  }),
  title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.noVulnerabilitiesStates.scanningVulnerabilitiesEmptyPrompt.indexingButtonTitle",
    defaultMessage: "Scanning your environment"
  })),
  body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.noVulnerabilitiesStates.scanningVulnerabilitiesEmptyPrompt.indexingDescription",
    defaultMessage: "Results will appear here as soon as they are available."
  }))
});
const CnvmIntegrationNotInstalledEmptyPrompt = ({
  vulnMgmtIntegrationLink
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": _test_subjects.NO_VULNERABILITIES_STATUS_TEST_SUBJ.NOT_INSTALLED,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      size: "fullWidth",
      src: _no_data_illustration.default,
      alt: "no-data-illustration"
    }),
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedHTMLMessage, {
      tagName: "h2",
      id: "xpack.csp.cloudPosturePage.vulnerabilitiesInstalledEmptyPrompt.promptTitle",
      defaultMessage: "Detect vulnerabilities in your <br/> cloud assets"
    })),
    layout: "horizontal",
    color: "plain",
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.cloudPosturePage.vulnerabilitiesInstalledEmptyPrompt.promptDescription",
      defaultMessage: "Add the Cloud Native Vulnerability Management integration to begin"
    })),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      fill: true,
      href: vulnMgmtIntegrationLink,
      "data-test-subj": _test_subjects.CNVM_NOT_INSTALLED_ACTION_SUBJ
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.cloudPosturePage.vulnerabilitiesInstalledEmptyPrompt.addVulMngtIntegrationButtonTitle",
      defaultMessage: "Install Cloud Native Vulnerability Management"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      color: "primary",
      href: 'https://ela.st/cnvm',
      target: "_blank"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.cloudPosturePage.vulnerabilitiesInstalledEmptyPrompt.learnMoreButtonTitle",
      defaultMessage: "Learn more"
    }))))
  });
};
const CnvmIndexTimeout = () => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  "data-test-subj": _test_subjects.NO_VULNERABILITIES_STATUS_TEST_SUBJ.INDEX_TIMEOUT,
  color: "plain",
  icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
    logo: "logoSecurity",
    size: "xl"
  }),
  title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.noVulnerabilitiesStates.indexTimeout.indexTimeoutTitle",
    defaultMessage: "Findings Delayed"
  })),
  body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.noVulnerabilitiesStates.indexTimeout.indexTimeoutDescription",
    defaultMessage: "Scanning workloads is taking longer than expected. Please check {docs}",
    values: {
      docs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://ela.st/cnvm-faq",
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.csp.noVulnerabilitiesStates.indexTimeout.indexTimeoutDocLink",
        defaultMessage: "CNVM FAQ"
      }))
    }
  }))
});
const Unprivileged = ({
  unprivilegedIndices
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  "data-test-subj": _test_subjects.NO_VULNERABILITIES_STATUS_TEST_SUBJ.UNPRIVILEGED,
  color: "plain",
  icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "logoSecurity",
    size: "xl"
  }),
  title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.noVulnerabilitiesStates.unprivileged.unprivilegedTitle",
    defaultMessage: "Privileges required"
  })),
  body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.noVulnerabilitiesStates.unprivileged.unprivilegedDescription",
    defaultMessage: "To view cloud posture data, you must update privileges. For more information, contact your Kibana administrator."
  })),
  footer: /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
    css: (0, _react2.css)`
          text-align: initial;
        `,
    children: _i18n.i18n.translate('xpack.csp.noVulnerabilitiesStates.unprivileged.unprivilegedFooterMarkdown', {
      defaultMessage: 'Required Elasticsearch index privilege `read` for the following indices:'
    }) + unprivilegedIndices.map(idx => `\n- \`${idx}\``)
  })
});
const AgentNotDeployedEmptyPrompt = ({
  postureType
}) => {
  const integrationPoliciesLink = (0, _use_navigate_to_cis_integration_policies.useCISIntegrationPoliciesLink)({
    postureType
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": _test_subjects.NO_VULNERABILITIES_STATUS_TEST_SUBJ.NOT_DEPLOYED,
    color: "plain",
    iconType: "fleetApp",
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.noVulnerabilitiesStates.noAgentsDeployed.noAgentsDeployedTitle",
      defaultMessage: "No Agents Installed"
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.noVulnerabilitiesStates.noAgentsDeployed.noAgentsDeployedDescription",
      defaultMessage: "In order to begin detecting vulnerabilities, you'll need to deploy elastic-agent into the cloud account or Kubernetes cluster you want to monitor."
    })),
    actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      href: integrationPoliciesLink,
      isDisabled: !integrationPoliciesLink
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.noVulnerabilitiesStates.noAgentsDeployed.noAgentsDeployedButtonTitle",
      defaultMessage: "Install Agent"
    }))]
  });
};

/**
 * This component will return the render states based on cloud posture setup status API
 * since 'not-installed' is being checked globally by CloudPosturePage and 'indexed' is the pass condition, those states won't be handled here
 * */
const NoVulnerabilitiesStates = () => {
  var _getSetupStatus$data, _getSetupStatus$data$, _getSetupStatus$data2;
  const getSetupStatus = (0, _use_setup_status_api.useCspSetupStatusApi)({
    refetchInterval: REFETCH_INTERVAL_MS
  });
  const vulnMgmtIntegrationLink = (0, _use_csp_integration_link.useCspIntegrationLink)(_constants.VULN_MGMT_POLICY_TEMPLATE);
  const status = (_getSetupStatus$data = getSetupStatus.data) === null || _getSetupStatus$data === void 0 ? void 0 : (_getSetupStatus$data$ = _getSetupStatus$data.vuln_mgmt) === null || _getSetupStatus$data$ === void 0 ? void 0 : _getSetupStatus$data$.status;
  const indicesStatus = (_getSetupStatus$data2 = getSetupStatus.data) === null || _getSetupStatus$data2 === void 0 ? void 0 : _getSetupStatus$data2.indicesDetails;
  const unprivilegedIndices = indicesStatus && indicesStatus.filter(idxDetails => idxDetails.status === 'unprivileged').map(idxDetails => idxDetails.index).sort((a, b) => a.localeCompare(b));
  const render = () => {
    if (status === 'indexing' || status === 'waiting_for_results') return /*#__PURE__*/_react.default.createElement(ScanningVulnerabilitiesEmptyPrompt, null); // integration installed, but no agents added// agent added, index timeout has passed
    if (status === 'index-timeout') return /*#__PURE__*/_react.default.createElement(CnvmIndexTimeout, null);
    if (status === 'not-installed') return /*#__PURE__*/_react.default.createElement(CnvmIntegrationNotInstalledEmptyPrompt, {
      vulnMgmtIntegrationLink: vulnMgmtIntegrationLink
    });
    if (status === 'not-deployed') return /*#__PURE__*/_react.default.createElement(AgentNotDeployedEmptyPrompt, {
      postureType: _constants.VULN_MGMT_POLICY_TEMPLATE
    });
    if (status === 'unprivileged') return /*#__PURE__*/_react.default.createElement(Unprivileged, {
      unprivilegedIndices: unprivilegedIndices || []
    }); // user has no privileges for our indices
  };

  return /*#__PURE__*/_react.default.createElement(_cloud_posture_page.CloudPosturePage, {
    query: getSetupStatus
  }, /*#__PURE__*/_react.default.createElement(_full_size_centered_page.FullSizeCenteredPage, null, render()));
};
exports.NoVulnerabilitiesStates = NoVulnerabilitiesStates;