"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInputVarsFields = exports.getAzureCredentialsFormOptions = exports.getAzureCredentialsFormManualOptions = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAzureCredentialsFormManualOptions = () => {
  return Object.entries(getAzureCredentialsFormOptions()).map(([key, value]) => ({
    value: key,
    text: value.label
  })).filter(({
    value
  }) => value !== 'arm_template' &&
  // we remove this in order to hide it from the selectable options in the manual drop down
  value !== 'manual' &&
  // TODO: remove 'manual' for stack version 8.13
  value !== 'service_principal_with_client_username_and_password' // this option is temporarily hidden
  );
};
exports.getAzureCredentialsFormManualOptions = getAzureCredentialsFormManualOptions;
const getInputVarsFields = (input, fields) => Object.entries(input.streams[0].vars || {}).filter(([id]) => id in fields).map(([id, inputVar]) => {
  const field = fields[id];
  return {
    id,
    label: field.label,
    type: field.type || 'text',
    value: inputVar.value
  };
});
exports.getInputVarsFields = getInputVarsFields;
const I18N_TENANT_ID = _i18n.i18n.translate('xpack.csp.azureIntegration.tenantIdLabel', {
  defaultMessage: 'Tenant ID'
});
const I18N_CLIENT_ID = _i18n.i18n.translate('xpack.csp.azureIntegration.clientIdLabel', {
  defaultMessage: 'Client ID'
});
const getAzureCredentialsFormOptions = () => ({
  managed_identity: {
    label: _i18n.i18n.translate('xpack.csp.azureIntegration.credentialType.managedIdentityLabel', {
      defaultMessage: 'Managed Identity'
    }),
    info: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.azureIntegration.credentialType.managedIdentityInfo",
      defaultMessage: "Ensure the agent is deployed on a resource that supports managed identities (e.g., Azure Virtual Machines). No explicit credentials need to be provided; Azure handles the authentication."
    })),
    fields: {}
  },
  arm_template: {
    label: 'ARM Template',
    info: [],
    fields: {}
  },
  // TODO: remove for stack version 8.13
  manual: {
    label: 'Manual',
    info: [],
    fields: {}
  },
  service_principal_with_client_secret: {
    label: _i18n.i18n.translate('xpack.csp.azureIntegration.servicePrincipalWithClientSecretLabel', {
      defaultMessage: 'Service principal with Client Secret'
    }),
    fields: {
      'azure.credentials.tenant_id': {
        label: I18N_TENANT_ID
      },
      'azure.credentials.client_id': {
        label: I18N_CLIENT_ID
      },
      'azure.credentials.client_secret': {
        type: 'password',
        label: _i18n.i18n.translate('xpack.csp.azureIntegration.clientSecretLabel', {
          defaultMessage: 'Client Secret'
        })
      }
    }
  },
  service_principal_with_client_certificate: {
    label: _i18n.i18n.translate('xpack.csp.azureIntegration.servicePrincipalWithClientCertificateLabel', {
      defaultMessage: 'Service principal with Client Certificate'
    }),
    fields: {
      'azure.credentials.tenant_id': {
        label: I18N_TENANT_ID
      },
      'azure.credentials.client_id': {
        label: I18N_CLIENT_ID
      },
      'azure.credentials.client_certificate_path': {
        label: _i18n.i18n.translate('xpack.csp.azureIntegration.clientCertificatePathLabel', {
          defaultMessage: 'Client Certificate Path'
        })
      },
      'azure.credentials.client_certificate_password': {
        type: 'password',
        label: _i18n.i18n.translate('xpack.csp.azureIntegration.clientCertificatePasswordLabel', {
          defaultMessage: 'Client Certificate Password'
        })
      }
    }
  },
  service_principal_with_client_username_and_password: {
    label: _i18n.i18n.translate('xpack.csp.azureIntegration.servicePrincipalWithClientUsernameAndPasswordLabel', {
      defaultMessage: 'Service principal with Client Username and Password'
    }),
    fields: {
      'azure.credentials.tenant_id': {
        label: I18N_TENANT_ID
      },
      'azure.credentials.client_id': {
        label: I18N_CLIENT_ID
      },
      'azure.credentials.client_username': {
        label: _i18n.i18n.translate('xpack.csp.azureIntegration.clientUsernameLabel', {
          defaultMessage: 'Client Username'
        })
      },
      'azure.credentials.client_password': {
        type: 'password',
        label: _i18n.i18n.translate('xpack.csp.azureIntegration.clientPasswordLabel', {
          defaultMessage: 'Client Password'
        })
      }
    }
  }
});
exports.getAzureCredentialsFormOptions = getAzureCredentialsFormOptions;