"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldsSelectorTable = exports.FieldsSelectorModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ACTION_COLUMN_WIDTH = '24px';
const defaultSorting = {
  sort: {
    field: 'name',
    direction: 'asc'
  }
};
const FieldsSelectorTable = ({
  title,
  dataView,
  columns,
  onAddColumn,
  onRemoveColumn
}) => {
  const dataViewFields = (0, _react.useMemo)(() => {
    return dataView.fields.getAll().filter(field => {
      return field.name !== '@timestamp' && field.name !== '_index' && field.visualizable;
    }).map(field => ({
      id: field.name,
      name: field.name,
      displayName: field.customLabel || ''
    }));
  }, [dataView.fields]);
  const [fields, setFields] = (0, _react.useState)(dataViewFields);
  let debounceTimeoutId;
  const onQueryChange = ({
    query
  }) => {
    clearTimeout(debounceTimeoutId);
    debounceTimeoutId = setTimeout(() => {
      const filteredItems = dataViewFields.filter(field => {
        const normalizedName = `${field.name} ${field.displayName}`.toLowerCase();
        const normalizedQuery = (query === null || query === void 0 ? void 0 : query.text.toLowerCase()) || '';
        return normalizedName.indexOf(normalizedQuery) !== -1;
      });
      setFields(filteredItems);
    }, 300);
  };
  const [fieldsSelected, setFieldsSelected] = (0, _react.useState)(columns);
  const tableColumns = [{
    field: 'action',
    name: '',
    width: ACTION_COLUMN_WIDTH,
    sortable: false,
    render: (_, {
      id
    }) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
        checked: fieldsSelected.includes(id),
        id: id,
        onChange: e => {
          const isChecked = e.target.checked;
          setFieldsSelected(isChecked ? [...fieldsSelected, id] : fieldsSelected.filter(f => f !== id));
          return isChecked ? onAddColumn(id) : onRemoveColumn(id);
        }
      });
    }
  }, {
    field: 'name',
    name: _i18n.i18n.translate('xpack.csp.dataTable.fieldsModalName', {
      defaultMessage: 'Name'
    }),
    sortable: true
  }, {
    field: 'displayName',
    name: _i18n.i18n.translate('xpack.csp.dataTable.fieldsModalCustomLabel', {
      defaultMessage: 'Custom Label'
    }),
    sortable: field => field.displayName.toLowerCase()
  }];
  const error = (0, _react.useMemo)(() => {
    if (!dataView || dataView.fields.length === 0) {
      return _i18n.i18n.translate('xpack.csp.dataTable.fieldsModalError', {
        defaultMessage: 'No fields found in the data view'
      });
    }
    return '';
  }, [dataView]);
  const search = {
    onChange: onQueryChange,
    box: {
      incremental: true,
      placeholder: _i18n.i18n.translate('xpack.csp.dataTable.fieldsModalSearch', {
        defaultMessage: 'Search field name'
      })
    }
  };
  const tableHeader = (0, _react.useMemo)(() => {
    const totalFields = fields.length;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      "data-test-subj": "csp:dataTable:fieldsModal:fieldsShowing",
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.dataTable.fieldsModalFieldsShowing",
      defaultMessage: "Showing"
    }), ' ', /*#__PURE__*/_react.default.createElement("strong", {
      "data-test-subj": "csp:dataTable:fieldsModal:fieldsCount"
    }, totalFields), ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.dataTable.fieldsModalFieldsCount",
      defaultMessage: "{totalFields, plural, one {field} other {fields}}",
      values: {
        totalFields
      }
    }))));
  }, [fields.length]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    tableCaption: title,
    items: fields,
    columns: tableColumns,
    search: search,
    pagination: true,
    sorting: defaultSorting,
    error: error,
    childrenBetween: tableHeader
  });
};
exports.FieldsSelectorTable = FieldsSelectorTable;
const FieldsSelectorModal = ({
  closeModal,
  dataView,
  columns,
  onAddColumn,
  onRemoveColumn
}) => {
  const title = _i18n.i18n.translate('xpack.csp.dataTable.fieldsModalTitle', {
    defaultMessage: 'Fields'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: closeModal
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(FieldsSelectorTable, {
    title: title,
    dataView: dataView,
    columns: columns,
    onAddColumn: onAddColumn,
    onRemoveColumn: onRemoveColumn
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: closeModal,
    fill: true
  }, "Close")));
};
exports.FieldsSelectorModal = FieldsSelectorModal;