"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCISIntegrationPoliciesLink = void 0;
var _public = require("@kbn/fleet-plugin/public");
var _use_cis_kubernetes_integration = require("../api/use_cis_kubernetes_integration");
var _use_kibana = require("../hooks/use_kibana");
var _use_csp_benchmark_integrations = require("../../pages/benchmarks/use_csp_benchmark_integrations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCISIntegrationPoliciesLink = ({
  postureType
}) => {
  var _cspBenchmarkIntegrat;
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  const cisIntegration = (0, _use_cis_kubernetes_integration.useCisKubernetesIntegration)();
  // using an existing hook to get agent id and package policy id
  const cspBenchmarkIntegrations = (0, _use_csp_benchmark_integrations.useCspBenchmarkIntegrations)({
    name: '',
    page: 1,
    perPage: 100,
    sortField: 'package_policy.name',
    sortOrder: 'asc'
  });
  if (!cisIntegration.isSuccess) return;
  const intergrations = (_cspBenchmarkIntegrat = cspBenchmarkIntegrations.data) === null || _cspBenchmarkIntegrat === void 0 ? void 0 : _cspBenchmarkIntegrat.items;
  const matchedIntegration = intergrations === null || intergrations === void 0 ? void 0 : intergrations.find(integration => {
    var _integration$package_, _integration$package_2, _integration$package_3;
    return (integration === null || integration === void 0 ? void 0 : (_integration$package_ = integration.package_policy) === null || _integration$package_ === void 0 ? void 0 : (_integration$package_2 = _integration$package_.inputs) === null || _integration$package_2 === void 0 ? void 0 : (_integration$package_3 = _integration$package_2.find(input => input === null || input === void 0 ? void 0 : input.enabled)) === null || _integration$package_3 === void 0 ? void 0 : _integration$package_3.policy_template) === postureType;
  });
  const addAgentToPolicyId = (matchedIntegration === null || matchedIntegration === void 0 ? void 0 : matchedIntegration.agent_policy.id) || '';
  const integration = (matchedIntegration === null || matchedIntegration === void 0 ? void 0 : matchedIntegration.package_policy.id) || '';
  const path = _public.pagePathGetters.integration_details_policies({
    addAgentToPolicyId,
    integration,
    pkgkey: (0, _public.pkgKeyFromPackageInfo)({
      name: cisIntegration.data.item.name,
      version: cisIntegration.data.item.version
    })
  }).join('');
  return http.basePath.prepend(path);
};
exports.useCISIntegrationPoliciesLink = useCISIntegrationPoliciesLink;