"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNavigateVulnerabilitiesByResource = exports.useNavigateVulnerabilities = exports.useNavigateFindingsByResource = exports.useNavigateFindings = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _constants = require("../../../common/constants");
var _constants2 = require("../navigation/constants");
var _query_utils = require("../navigation/query_utils");
var _use_kibana = require("./use_kibana");
var _use_latest_findings_data_view = require("../api/use_latest_findings_data_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createFilter = (key, filterValue, dataViewId) => {
  let negate = false;
  let value = filterValue;
  if (typeof filterValue === 'object') {
    negate = filterValue.negate;
    value = filterValue.value;
  }
  // If the value is '*', we want to create an exists filter
  if (value === '*') {
    return {
      query: {
        exists: {
          field: key
        }
      },
      meta: {
        type: 'exists',
        index: dataViewId
      }
    };
  }
  return {
    meta: {
      alias: null,
      negate,
      disabled: false,
      type: 'phrase',
      key,
      index: dataViewId
    },
    query: {
      match_phrase: {
        [key]: value
      }
    }
  };
};
const useNavigate = (pathname, dataViewId = _constants.SECURITY_DEFAULT_DATA_VIEW_ID) => {
  const history = (0, _reactRouterDom.useHistory)();
  const {
    services
  } = (0, _use_kibana.useKibana)();
  return (0, _react.useCallback)((filterParams = {}) => {
    const filters = Object.entries(filterParams).map(([key, filterValue]) => createFilter(key, filterValue, dataViewId));
    history.push({
      pathname,
      search: (0, _query_utils.encodeQuery)({
        // Set query language from user's preference
        query: services.data.query.queryString.getDefaultQuery(),
        filters
      })
    });
  }, [pathname, history, services.data.query.queryString, dataViewId]);
};
const useNavigateFindings = () => {
  const {
    data
  } = (0, _use_latest_findings_data_view.useLatestFindingsDataView)(_constants.LATEST_FINDINGS_INDEX_PATTERN);
  return useNavigate(_constants2.findingsNavigation.findings_default.path, data === null || data === void 0 ? void 0 : data.id);
};
exports.useNavigateFindings = useNavigateFindings;
const useNavigateFindingsByResource = () => {
  const {
    data
  } = (0, _use_latest_findings_data_view.useLatestFindingsDataView)(_constants.LATEST_FINDINGS_INDEX_PATTERN);
  return useNavigate(_constants2.findingsNavigation.findings_by_resource.path, data === null || data === void 0 ? void 0 : data.id);
};
exports.useNavigateFindingsByResource = useNavigateFindingsByResource;
const useNavigateVulnerabilities = () => useNavigate(_constants2.findingsNavigation.vulnerabilities.path);
exports.useNavigateVulnerabilities = useNavigateVulnerabilities;
const useNavigateVulnerabilitiesByResource = () => useNavigate(_constants2.findingsNavigation.vulnerabilities_by_resource.path);
exports.useNavigateVulnerabilitiesByResource = useNavigateVulnerabilitiesByResource;