"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBaseEsQuery = void 0;
var _esQuery = require("@kbn/es-query");
var _i18n = require("@kbn/i18n");
var _react = require("react");
var _use_kibana = require("../use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getBaseQuery = ({
  dataView,
  query,
  filters,
  config
}) => {
  try {
    return {
      query: (0, _esQuery.buildEsQuery)(dataView, query, filters, config) // will throw for malformed query
    };
  } catch (error) {
    return {
      query: undefined,
      error: error instanceof Error ? error : new Error('Unknown Error')
    };
  }
};
const useBaseEsQuery = ({
  dataView,
  filters = [],
  query,
  nonPersistedFilters
}) => {
  const {
    notifications: {
      toasts
    },
    data: {
      query: {
        filterManager,
        queryString
      }
    },
    uiSettings
  } = (0, _use_kibana.useKibana)().services;
  const allowLeadingWildcards = uiSettings.get('query:allowLeadingWildcards');
  const config = (0, _react.useMemo)(() => ({
    allowLeadingWildcards
  }), [allowLeadingWildcards]);
  const baseEsQuery = (0, _react.useMemo)(() => getBaseQuery({
    dataView,
    filters: filters.concat(nonPersistedFilters !== null && nonPersistedFilters !== void 0 ? nonPersistedFilters : []).flat(),
    query,
    config
  }), [dataView, filters, nonPersistedFilters, query, config]);

  /**
   * Sync filters with the URL query
   */
  (0, _react.useEffect)(() => {
    filterManager.setAppFilters(filters);
    queryString.setQuery(query);
  }, [filters, filterManager, queryString, query]);
  const handleMalformedQueryError = () => {
    const error = baseEsQuery instanceof Error ? baseEsQuery : undefined;
    if (error) {
      toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.csp.findings.search.queryErrorToastMessage', {
          defaultMessage: 'Query Error'
        }),
        toastLifeTimeMs: 1000 * 5
      });
    }
  };
  (0, _react.useEffect)(handleMalformedQueryError, [baseEsQuery, toasts]);
  return baseEsQuery;
};
exports.useBaseEsQuery = useBaseEsQuery;