"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCspSetupStatusApi = void 0;
var _reactQuery = require("@tanstack/react-query");
var _use_kibana = require("../hooks/use_kibana");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCspSetupStatusQueryKey = 'csp_status_key';
const useCspSetupStatusApi = options => {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  return (0, _reactQuery.useQuery)([getCspSetupStatusQueryKey], () => http.get(_constants.STATUS_ROUTE_PATH, {
    version: _constants.STATUS_API_CURRENT_VERSION
  }), options);
};
exports.useCspSetupStatusApi = useCspSetupStatusApi;