"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLicenseManagementLocatorApi = void 0;
var _reactQuery = require("@tanstack/react-query");
var _use_kibana = require("../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LICENSE_MANAGEMENT_LOCATOR = 'LICENSE_MANAGEMENT_LOCATOR';
const getLicenseManagementLocatorKey = 'license_management_url_key';
const useLicenseManagementLocatorApi = () => {
  const {
    share
  } = (0, _use_kibana.useKibana)().services;
  return (0, _reactQuery.useQuery)([getLicenseManagementLocatorKey], () => {
    const locator = share.url.locators.get(LICENSE_MANAGEMENT_LOCATOR);
    // license management does not exist on serverless
    if (!locator) return;
    return locator.getUrl({
      page: 'dashboard'
    });
  });
};
exports.useLicenseManagementLocatorApi = useLicenseManagementLocatorApi;