"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLatestFindingsDataView = void 0;
var _reactQuery = require("@tanstack/react-query");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const cloudSecurityFieldLabels = {
  'result.evaluation': _i18n.i18n.translate('xpack.csp.findings.findingsTable.findingsTableColumn.resultColumnLabel', {
    defaultMessage: 'Result'
  }),
  'resource.id': _i18n.i18n.translate('xpack.csp.findings.findingsTable.findingsTableColumn.resourceIdColumnLabel', {
    defaultMessage: 'Resource ID'
  }),
  'resource.name': _i18n.i18n.translate('xpack.csp.findings.findingsTable.findingsTableColumn.resourceNameColumnLabel', {
    defaultMessage: 'Resource Name'
  }),
  'resource.sub_type': _i18n.i18n.translate('xpack.csp.findings.findingsTable.findingsTableColumn.resourceTypeColumnLabel', {
    defaultMessage: 'Resource Type'
  }),
  'rule.benchmark.rule_number': _i18n.i18n.translate('xpack.csp.findings.findingsTable.findingsTableColumn.ruleNumberColumnLabel', {
    defaultMessage: 'Rule Number'
  }),
  'rule.name': _i18n.i18n.translate('xpack.csp.findings.findingsTable.findingsTableColumn.ruleNameColumnLabel', {
    defaultMessage: 'Rule Name'
  }),
  'rule.section': _i18n.i18n.translate('xpack.csp.findings.findingsTable.findingsTableColumn.ruleSectionColumnLabel', {
    defaultMessage: 'CIS Section'
  }),
  '@timestamp': _i18n.i18n.translate('xpack.csp.findings.findingsTable.findingsTableColumn.lastCheckedColumnLabel', {
    defaultMessage: 'Last Checked'
  })
};

/**
 *  TODO: use perfected kibana data views
 */
const useLatestFindingsDataView = dataView => {
  const {
    data: {
      dataViews
    }
  } = (0, _public.useKibana)().services;
  const findDataView = async () => {
    const [dataViewObj] = await dataViews.find(dataView);
    if (!dataViewObj) {
      throw new Error(`Data view not found [Name: {${dataView}}]`);
    }
    if (dataView === _constants.LATEST_FINDINGS_INDEX_PATTERN) {
      Object.entries(cloudSecurityFieldLabels).forEach(([field, label]) => {
        var _dataViewObj$getField, _dataViewObj$getField2;
        if (!((_dataViewObj$getField = dataViewObj.getFieldAttrs()[field]) !== null && _dataViewObj$getField !== void 0 && _dataViewObj$getField.customLabel) || ((_dataViewObj$getField2 = dataViewObj.getFieldAttrs()[field]) === null || _dataViewObj$getField2 === void 0 ? void 0 : _dataViewObj$getField2.customLabel) === field) {
          dataViewObj.setFieldCustomLabel(field, label);
        }
      });
      await dataViews.updateSavedObject(dataViewObj);
    }
    return dataViewObj;
  };
  return (0, _reactQuery.useQuery)([`useDataView-${dataView}`], findDataView);
};
exports.useLatestFindingsDataView = useLatestFindingsDataView;