"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TAGS_FIELD = exports.DETECTION_ENGINE_RULES_URL_FIND = void 0;
exports.convertRuleTagsToKQL = convertRuleTagsToKQL;
exports.useFetchDetectionRulesByTags = void 0;
var _public = require("@kbn/kibana-react-plugin/public");
var _reactQuery = require("@tanstack/react-query");
var _constants = require("../../../common/constants");
var _constants2 = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TAGS_FIELD = 'alert.attributes.tags';
exports.TAGS_FIELD = TAGS_FIELD;
const DETECTION_ENGINE_URL = '/api/detection_engine';
const DETECTION_ENGINE_RULES_URL = `${DETECTION_ENGINE_URL}/rules`;
const DETECTION_ENGINE_RULES_URL_FIND = `${DETECTION_ENGINE_RULES_URL}/_find`;
exports.DETECTION_ENGINE_RULES_URL_FIND = DETECTION_ENGINE_RULES_URL_FIND;
function convertRuleTagsToKQL(tags) {
  return `${TAGS_FIELD}:(${tags.map(tag => `"${tag}"`).join(' AND ')})`;
}
const useFetchDetectionRulesByTags = tags => {
  const {
    http
  } = (0, _public.useKibana)().services;
  const query = {
    page: 1,
    per_page: 1,
    filter: convertRuleTagsToKQL(tags)
  };
  return (0, _reactQuery.useQuery)([_constants2.DETECTION_ENGINE_RULES_KEY, tags], () => http.fetch(DETECTION_ENGINE_RULES_URL_FIND, {
    method: 'GET',
    version: _constants.DETECTION_RULE_RULES_API_CURRENT_VERSION,
    query
  }));
};
exports.useFetchDetectionRulesByTags = useFetchDetectionRulesByTags;