"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CSP_FLEET_PACKAGE_KUERY = void 0;
exports.assert = assert;
exports.truthy = exports.roundScore = exports.isNonNullable = exports.isEnabledBenchmarkInputType = exports.isCspPackage = exports.getStatusForIndexName = exports.getBenchmarkFromPackagePolicy = exports.getBenchmarkFilter = exports.extractErrorMessage = exports.cleanupCredentials = exports.calculatePostureScore = void 0;
var _common = require("@kbn/fleet-plugin/common");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * @example
 * declare const foo: Array<string | undefined | null>
 * foo.filter(isNonNullable) // foo is Array<string>
 */
const isNonNullable = v => v !== null && v !== undefined;
exports.isNonNullable = isNonNullable;
const truthy = value => !!value;
exports.truthy = truthy;
const extractErrorMessage = (e, defaultMessage = 'Unknown Error') => {
  if (e instanceof Error) return e.message;
  if (typeof e === 'string') return e;
  return defaultMessage; // TODO: i18n
};
exports.extractErrorMessage = extractErrorMessage;
const getBenchmarkFilter = (type, section) => `${_constants.CSP_RULE_TEMPLATE_SAVED_OBJECT_TYPE}.attributes.metadata.benchmark.id: "${type}"${section ? ` AND ${_constants.CSP_RULE_TEMPLATE_SAVED_OBJECT_TYPE}.attributes.metadata.section: "${section}"` : ''}`;
exports.getBenchmarkFilter = getBenchmarkFilter;
const isEnabledBenchmarkInputType = input => input.enabled;
exports.isEnabledBenchmarkInputType = isEnabledBenchmarkInputType;
const isCspPackage = packageName => packageName === _constants.CLOUD_SECURITY_POSTURE_PACKAGE_NAME;
exports.isCspPackage = isCspPackage;
const getBenchmarkFromPackagePolicy = inputs => {
  const enabledInputs = inputs.filter(isEnabledBenchmarkInputType);

  // Use the only enabled input
  if (enabledInputs.length === 1) {
    return getInputType(enabledInputs[0].type);
  }

  // Use the default benchmark id for multiple/none selected
  return getInputType(_constants.CLOUDBEAT_VANILLA);
};
exports.getBenchmarkFromPackagePolicy = getBenchmarkFromPackagePolicy;
const getInputType = inputType => {
  // Get the last part of the input type, input type structure: cloudbeat/<benchmark_id>
  return inputType.split('/')[1];
};
const CSP_FLEET_PACKAGE_KUERY = `${_common.PACKAGE_POLICY_SAVED_OBJECT_TYPE}.package.name:${_constants.CLOUD_SECURITY_POSTURE_PACKAGE_NAME}`;
exports.CSP_FLEET_PACKAGE_KUERY = CSP_FLEET_PACKAGE_KUERY;
function assert(condition, msg) {
  if (!condition) {
    throw new Error(msg);
  }
}

/**
 * @param value value is [0, 1] range
 */
const roundScore = value => Number((value * 100).toFixed(1));
exports.roundScore = roundScore;
const calculatePostureScore = (passed, failed) => {
  const total = passed + failed;
  if (total === 0) return total;
  return roundScore(passed / (passed + failed));
};
exports.calculatePostureScore = calculatePostureScore;
const getStatusForIndexName = (indexName, status) => {
  if (status) {
    const indexDetail = status.indicesDetails.find(details => details.index.indexOf(indexName) !== -1);
    if (indexDetail) {
      return indexDetail.status;
    }
  }
  return 'unknown';
};
exports.getStatusForIndexName = getStatusForIndexName;
const cleanupCredentials = packagePolicy => {
  var _enabledInput$streams, _enabledInput$streams2, _enabledInput$streams3, _enabledInput$streams4, _enabledInput$streams5, _enabledInput$streams6, _enabledInput$streams7, _enabledInput$streams8, _enabledInput$streams9;
  const enabledInput = packagePolicy.inputs.find(i => i.enabled);
  const awsCredentialType = enabledInput === null || enabledInput === void 0 ? void 0 : (_enabledInput$streams = enabledInput.streams) === null || _enabledInput$streams === void 0 ? void 0 : (_enabledInput$streams2 = _enabledInput$streams[0].vars) === null || _enabledInput$streams2 === void 0 ? void 0 : (_enabledInput$streams3 = _enabledInput$streams2['aws.credentials.type']) === null || _enabledInput$streams3 === void 0 ? void 0 : _enabledInput$streams3.value;
  const gcpCredentialType = enabledInput === null || enabledInput === void 0 ? void 0 : (_enabledInput$streams4 = enabledInput.streams) === null || _enabledInput$streams4 === void 0 ? void 0 : (_enabledInput$streams5 = _enabledInput$streams4[0].vars) === null || _enabledInput$streams5 === void 0 ? void 0 : (_enabledInput$streams6 = _enabledInput$streams5['gcp.credentials.type']) === null || _enabledInput$streams6 === void 0 ? void 0 : _enabledInput$streams6.value;
  const azureCredentialType = enabledInput === null || enabledInput === void 0 ? void 0 : (_enabledInput$streams7 = enabledInput.streams) === null || _enabledInput$streams7 === void 0 ? void 0 : (_enabledInput$streams8 = _enabledInput$streams7[0].vars) === null || _enabledInput$streams8 === void 0 ? void 0 : (_enabledInput$streams9 = _enabledInput$streams8['azure.credentials.type']) === null || _enabledInput$streams9 === void 0 ? void 0 : _enabledInput$streams9.value;
  if (awsCredentialType || gcpCredentialType || azureCredentialType) {
    let credsToKeep = [' '];
    let credFields = [' '];
    if (awsCredentialType) {
      credsToKeep = _constants.AWS_CREDENTIALS_TYPE_TO_FIELDS_MAP[awsCredentialType];
      credFields = Object.values(_constants.AWS_CREDENTIALS_TYPE_TO_FIELDS_MAP).flat();
    } else if (gcpCredentialType) {
      credsToKeep = _constants.GCP_CREDENTIALS_TYPE_TO_FIELDS_MAP[gcpCredentialType];
      credFields = Object.values(_constants.GCP_CREDENTIALS_TYPE_TO_FIELDS_MAP).flat();
    } else if (azureCredentialType) {
      credsToKeep = _constants.AZURE_CREDENTIALS_TYPE_TO_FIELDS_MAP[azureCredentialType];
      credFields = Object.values(_constants.AZURE_CREDENTIALS_TYPE_TO_FIELDS_MAP).flat();
    }
    if (credsToKeep) {
      // we need to return a copy of the policy with the unused
      // credentials set to undefined
      return {
        ...packagePolicy,
        inputs: packagePolicy.inputs.map(input => {
          if (input.enabled) {
            return {
              ...input,
              streams: input.streams.map(stream => {
                const vars = stream.vars;
                for (const field in vars) {
                  if (!credsToKeep.includes(field) && credFields.includes(field)) {
                    vars[field].value = undefined;
                  }
                }
                return {
                  ...stream,
                  vars
                };
              })
            };
          }
          return input;
        })
      };
    }
  }

  // nothing to do, return unmutated policy
  return packagePolicy;
};
exports.cleanupCredentials = cleanupCredentials;