"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCommonChartStyles = void 0;
var _react = require("@emotion/react");
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _react2 = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const useCommonChartStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const subdued = (0, _react2.useMemo)(() => (0, _react.css)`
      fill: ${euiTheme.colors.subduedText};
    `, [euiTheme.colors.subduedText]);
  const accent = (0, _react.css)`
    fill: ${_uiTheme.euiThemeVars.euiColorVis0};
  `;
  return {
    chartIcon: {
      subdued,
      accent
    }
  };
};
exports.useCommonChartStyles = useCommonChartStyles;