"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkDeleteFileAttachments = void 0;
var _configSchema = require("@kbn/config-schema");
var _api = require("../../../../common/api");
var _constants = require("../../../../common/constants");
var _create_cases_route = require("../create_cases_route");
var _error = require("../../../common/error");
var _utils = require("../utils");
var _v = require("../../../../common/types/api/attachment/v1");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const bulkDeleteFileAttachments = (0, _create_cases_route.createCasesRoute)({
  method: 'post',
  path: _constants.INTERNAL_DELETE_FILE_ATTACHMENTS_URL,
  params: {
    params: _configSchema.schema.object({
      case_id: _configSchema.schema.string()
    }),
    body: _utils.escapeHatch
  },
  handler: async ({
    context,
    request,
    response
  }) => {
    try {
      const caseContext = await context.cases;
      const client = await caseContext.getCasesClient();
      const requestBody = (0, _api.decodeWithExcessOrThrow)(_v.BulkDeleteFileAttachmentsRequestRt)(request.body);
      await client.attachments.bulkDeleteFileAttachments({
        caseId: request.params.case_id,
        fileIds: requestBody.ids
      });
      return response.noContent();
    } catch (error) {
      throw (0, _error.createCaseError)({
        message: `Failed to delete files in route case id: ${request.params.case_id}: ${error}`,
        error
      });
    }
  }
});
exports.bulkDeleteFileAttachments = bulkDeleteFileAttachments;