"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.postCaseConfigureRoute = void 0;
var _api = require("../../../../common/types/api");
var _api2 = require("../../../../common/api");
var _constants = require("../../../../common/constants");
var _error = require("../../../common/error");
var _create_cases_route = require("../create_cases_route");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const postCaseConfigureRoute = (0, _create_cases_route.createCasesRoute)({
  method: 'post',
  path: _constants.CASE_CONFIGURE_URL,
  handler: async ({
    context,
    request,
    response
  }) => {
    try {
      const query = (0, _api2.decodeWithExcessOrThrow)(_api.ConfigurationRequestRt)(request.body);
      const caseContext = await context.cases;
      const client = await caseContext.getCasesClient();
      const res = await client.configure.create(query);
      return response.ok({
        body: res
      });
    } catch (error) {
      throw (0, _error.createCaseError)({
        message: `Failed to post case configure in route: ${error}`,
        error
      });
    }
  }
});
exports.postCaseConfigureRoute = postCaseConfigureRoute;