"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerInternalAttachments = void 0;
var _boom = require("@hapi/boom");
var _domain = require("../../common/types/domain");
var _visualizations = require("../../common/constants/visualizations");
var _constants = require("../../common/constants");
var _api = require("../../common/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerInternalAttachments = (externalRefRegistry, persistableStateRegistry) => {
  externalRefRegistry.register({
    id: _constants.FILE_ATTACHMENT_TYPE,
    schemaValidator
  });
  persistableStateRegistry.register({
    id: _visualizations.LENS_ATTACHMENT_TYPE
  });
};
exports.registerInternalAttachments = registerInternalAttachments;
const schemaValidator = data => {
  const fileMetadata = (0, _api.decodeWithExcessOrThrow)(_domain.FileAttachmentMetadataRt)(data);
  if (fileMetadata.files.length > 1) {
    throw (0, _boom.badRequest)('Only a single file can be stored in an attachment');
  }
};