"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetCases = exports.initialData = void 0;
var _reactQuery = require("@tanstack/react-query");
var _constants = require("./constants");
var _kibana = require("../common/lib/kibana");
var i18n = _interopRequireWildcard(require("./translations"));
var _api = require("./api");
var _use_cases_context = require("../components/cases_context/use_cases_context");
var _use_available_owners = require("../components/app/use_available_owners");
var _permissions = require("../utils/permissions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialData = {
  cases: [],
  countClosedCases: 0,
  countInProgressCases: 0,
  countOpenCases: 0,
  page: 0,
  perPage: 0,
  total: 0
};
exports.initialData = initialData;
const useGetCases = (params = {}) => {
  var _params$filterOptions;
  const toasts = (0, _kibana.useToasts)();
  const {
    owner
  } = (0, _use_cases_context.useCasesContext)();
  const availableSolutions = (0, _use_available_owners.useAvailableCasesOwners)((0, _permissions.getAllPermissionsExceptFrom)('delete'));
  const hasOwner = !!owner.length;
  const initialOwner = hasOwner ? owner : availableSolutions;
  const ownerFilter = ((_params$filterOptions = params.filterOptions) === null || _params$filterOptions === void 0 ? void 0 : _params$filterOptions.owner) != null && params.filterOptions.owner.length > 0 ? {
    owner: params.filterOptions.owner
  } : {
    owner: initialOwner
  };
  return (0, _reactQuery.useQuery)(_constants.casesQueriesKeys.cases(params), ({
    signal
  }) => {
    var _params$filterOptions2, _params$queryParams;
    return (0, _api.getCases)({
      filterOptions: {
        ..._constants.DEFAULT_FILTER_OPTIONS,
        ...((_params$filterOptions2 = params.filterOptions) !== null && _params$filterOptions2 !== void 0 ? _params$filterOptions2 : {}),
        ...ownerFilter
      },
      queryParams: {
        ..._constants.DEFAULT_QUERY_PARAMS,
        ...((_params$queryParams = params.queryParams) !== null && _params$queryParams !== void 0 ? _params$queryParams : {})
      },
      signal
    });
  }, {
    keepPreviousData: true,
    onError: error => {
      if (error.name !== 'AbortError') {
        toasts.addError(error.body && error.body.message ? new Error(error.body.message) : error, {
          title: i18n.ERROR_TITLE
        });
      }
    }
  });
};
exports.useGetCases = useGetCases;