"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAddToNewCaseLensAction = exports.DEFAULT_DARK_MODE = exports.ACTION_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactDom = require("react-dom");
var _public = require("@kbn/ui-actions-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
var _public3 = require("@kbn/kibana-react-plugin/public");
var _owner = require("../../../../common/utils/owner");
var _utils = require("./utils");
var _translations = require("./translations");
var _use_cases_add_to_new_case_flyout = require("../../create/flyout/use_cases_add_to_new_case_flyout");
var _action_wrapper = require("./action_wrapper");
var _can_use_cases = require("../../../client/helpers/can_use_cases");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ACTION_ID = 'embeddable_addToNewCase';
exports.ACTION_ID = ACTION_ID;
const DEFAULT_DARK_MODE = 'theme:darkMode';
exports.DEFAULT_DARK_MODE = DEFAULT_DARK_MODE;
const AddToNewCaseFlyoutWrapper = ({
  embeddable,
  onClose,
  onSuccess
}) => {
  const {
    timeRange
  } = embeddable.getInput();
  const attributes = embeddable.getFullAttributes();
  const createNewCaseFlyout = (0, _use_cases_add_to_new_case_flyout.useCasesAddToNewCaseFlyout)({
    onClose,
    onSuccess,
    toastContent: _translations.ADD_TO_CASE_SUCCESS
  });

  // we've checked attributes exists before rendering (isCompatible), attributes should not be undefined here
  const attachments = (0, _react.useMemo)(() => attributes != null ? [(0, _utils.getLensCaseAttachment)({
    attributes,
    timeRange
  })] : [], [attributes, timeRange]);
  (0, _react.useEffect)(() => {
    createNewCaseFlyout.open({
      attachments
    });
  }, [attachments, createNewCaseFlyout]);
  return null;
};
AddToNewCaseFlyoutWrapper.displayName = 'AddToNewCaseFlyoutWrapper';
const createAddToNewCaseLensAction = ({
  core,
  plugins,
  storage,
  history,
  caseContextProps
}) => {
  const {
    application: applicationService,
    theme
  } = core;
  let currentAppId;
  applicationService === null || applicationService === void 0 ? void 0 : applicationService.currentAppId$.subscribe(appId => {
    currentAppId = appId;
  });
  return (0, _public.createAction)({
    id: ACTION_ID,
    type: 'actionButton',
    getIconType: () => 'casesApp',
    getDisplayName: () => _translations.ADD_TO_NEW_CASE_DISPLAYNAME,
    isCompatible: async ({
      embeddable
    }) => {
      const owner = (0, _owner.getCaseOwnerByAppId)(currentAppId);
      const casePermissions = (0, _can_use_cases.canUseCases)(applicationService.capabilities)(owner ? [owner] : undefined);
      return !(0, _public2.isErrorEmbeddable)(embeddable) && (0, _utils.isLensEmbeddable)(embeddable) && casePermissions.update && casePermissions.create && (0, _utils.hasInput)(embeddable);
    },
    execute: async ({
      embeddable
    }) => {
      const targetDomElement = document.createElement('div');
      const cleanupDom = () => {
        if (targetDomElement != null) {
          (0, _reactDom.unmountComponentAtNode)(targetDomElement);
        }
      };
      const onFlyoutClose = () => {
        cleanupDom();
      };
      const mount = (0, _public3.toMountPoint)( /*#__PURE__*/_react.default.createElement(_action_wrapper.ActionWrapper, {
        core: core,
        caseContextProps: caseContextProps,
        storage: storage,
        plugins: plugins,
        history: history,
        currentAppId: currentAppId
      }, /*#__PURE__*/_react.default.createElement(AddToNewCaseFlyoutWrapper, {
        embeddable: embeddable,
        onClose: onFlyoutClose,
        onSuccess: onFlyoutClose
      })), {
        theme$: theme.theme$
      });
      mount(targetDomElement);
    }
  });
};
exports.createAddToNewCaseLensAction = createAddToNewCaseLensAction;