"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserCommentPropertyActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _types = require("../../../client/attachment_framework/types");
var _use_cases_context = require("../../cases_context/use_cases_context");
var _use_lens_open_visualization = require("../../markdown_editor/plugins/lens/use_lens_open_visualization");
var i18n = _interopRequireWildcard(require("./translations"));
var _property_actions = require("./property_actions");
var _delete_attachment_confirmation_modal = require("../delete_attachment_confirmation_modal");
var _use_delete_property_action = require("./use_delete_property_action");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UserCommentPropertyActionsComponent = ({
  isLoading,
  commentContent,
  onEdit,
  onDelete,
  onQuote
}) => {
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const {
    showDeletionModal,
    onModalOpen,
    onConfirm,
    onCancel
  } = (0, _use_delete_property_action.useDeletePropertyAction)({
    onDelete
  });
  const {
    canUseEditor,
    actionConfig
  } = (0, _use_lens_open_visualization.useLensOpenVisualization)({
    comment: commentContent !== null && commentContent !== void 0 ? commentContent : ''
  });
  const propertyActions = (0, _react.useMemo)(() => {
    const showEditPencilIcon = permissions.update;
    const showTrashIcon = permissions.delete;
    const showQuoteIcon = permissions.create;
    const showLensEditor = permissions.update && canUseEditor && actionConfig;
    return [...(showEditPencilIcon ? [{
      type: _types.AttachmentActionType.BUTTON,
      iconType: 'pencil',
      label: i18n.EDIT_COMMENT,
      onClick: onEdit
    }] : []), ...(showQuoteIcon ? [{
      type: _types.AttachmentActionType.BUTTON,
      iconType: 'quote',
      label: i18n.QUOTE,
      onClick: onQuote
    }] : []), ...(showTrashIcon ? [{
      type: _types.AttachmentActionType.BUTTON,
      iconType: 'trash',
      color: 'danger',
      label: i18n.DELETE_COMMENT,
      onClick: onModalOpen
    }] : []), ...(showLensEditor ? [actionConfig] : [])];
  }, [permissions.update, permissions.delete, permissions.create, canUseEditor, actionConfig, onEdit, onModalOpen, onQuote]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_property_actions.UserActionPropertyActions, {
    isLoading: isLoading,
    propertyActions: propertyActions
  }), showDeletionModal ? /*#__PURE__*/_react.default.createElement(_delete_attachment_confirmation_modal.DeleteAttachmentConfirmationModal, {
    title: i18n.DELETE_COMMENT_TITLE,
    confirmButtonText: i18n.DELETE,
    onCancel: onCancel,
    onConfirm: onConfirm
  }) : null);
};
UserCommentPropertyActionsComponent.displayName = 'UserCommentPropertyActions';
const UserCommentPropertyActions = /*#__PURE__*/_react.default.memo(UserCommentPropertyActionsComponent);
exports.UserCommentPropertyActions = UserCommentPropertyActions;