"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserActionPropertyActions = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _property_actions = require("../../property_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UserActionPropertyActionsComponent = ({
  isLoading,
  propertyActions,
  customDataTestSubj = 'user-action'
}) => {
  if (propertyActions.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    "data-test-subj": "user-action-title-loading"
  }) : /*#__PURE__*/_react.default.createElement(_property_actions.PropertyActions, {
    propertyActions: propertyActions,
    customDataTestSubj: customDataTestSubj
  }));
};
UserActionPropertyActionsComponent.displayName = 'UserActionPropertyActions';
const UserActionPropertyActions = /*#__PURE__*/_react.default.memo(UserActionPropertyActionsComponent);
exports.UserActionPropertyActions = UserActionPropertyActions;