"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NO_PRIVILEGES_TITLE = exports.NO_PRIVILEGES_MSG = exports.NO_PRIVILEGES_BUTTON = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NO_PRIVILEGES_MSG = pageName => _i18n.i18n.translate('xpack.cases.noPrivileges.message', {
  values: {
    pageName
  },
  defaultMessage: 'To view {pageName} page, you must update privileges. For more information, contact your Kibana administrator.'
});
exports.NO_PRIVILEGES_MSG = NO_PRIVILEGES_MSG;
const NO_PRIVILEGES_TITLE = _i18n.i18n.translate('xpack.cases.noPrivileges.title', {
  defaultMessage: 'Privileges required'
});
exports.NO_PRIVILEGES_TITLE = NO_PRIVILEGES_TITLE;
const NO_PRIVILEGES_BUTTON = _i18n.i18n.translate('xpack.cases.noPrivileges.button', {
  defaultMessage: 'Back to Cases'
});
exports.NO_PRIVILEGES_BUTTON = NO_PRIVILEGES_BUTTON;