"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoPrivilegesPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _navigation = require("../../common/navigation");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NoPrivilegesPage = /*#__PURE__*/_react.default.memo(({
  pageName
}) => {
  const {
    navigateToAllCases
  } = (0, _navigation.useAllCasesNavigation)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconColor: "default",
    iconType: "casesApp",
    title: /*#__PURE__*/_react.default.createElement("h2", null, i18n.NO_PRIVILEGES_TITLE),
    titleSize: "xs",
    body: /*#__PURE__*/_react.default.createElement("p", null, i18n.NO_PRIVILEGES_MSG(pageName)),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: navigateToAllCases,
      size: "s",
      color: "primary",
      fill: true
    }, i18n.NO_PRIVILEGES_BUTTON)
  });
});
exports.NoPrivilegesPage = NoPrivilegesPage;
NoPrivilegesPage.displayName = 'NoPrivilegesPage';