"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MarkdownEditor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_plugins = require("./use_plugins");
var _use_lens_button_toggle = require("./plugins/lens/use_lens_button_toggle");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MarkdownEditorComponent = /*#__PURE__*/(0, _react.forwardRef)(({
  ariaLabel,
  dataTestSubj,
  editorId,
  height,
  onChange,
  value,
  disabledUiPlugins
}, ref) => {
  const astRef = (0, _react.useRef)(undefined);
  const [markdownErrorMessages, setMarkdownErrorMessages] = (0, _react.useState)([]);
  const onParse = (0, _react.useCallback)((err, {
    messages,
    ast
  }) => {
    setMarkdownErrorMessages(err ? [err] : messages);
    astRef.current = ast;
  }, []);
  const {
    parsingPlugins,
    processingPlugins,
    uiPlugins
  } = (0, _use_plugins.usePlugins)(disabledUiPlugins);
  const editorRef = (0, _react.useRef)(null);
  (0, _use_lens_button_toggle.useLensButtonToggle)({
    astRef,
    uiPlugins,
    editorRef: ref,
    value
  });

  // @ts-expect-error
  (0, _react.useImperativeHandle)(ref, () => {
    var _editorRef$current, _editorRef$current$te;
    if (!editorRef.current) {
      return null;
    }
    const editorNode = (_editorRef$current = editorRef.current) === null || _editorRef$current === void 0 ? void 0 : (_editorRef$current$te = _editorRef$current.textarea) === null || _editorRef$current$te === void 0 ? void 0 : _editorRef$current$te.closest('.euiMarkdownEditor');
    return {
      ...editorRef.current,
      toolbar: editorNode === null || editorNode === void 0 ? void 0 : editorNode.querySelector('.euiMarkdownEditorToolbar')
    };
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownEditor, {
    ref: editorRef,
    "aria-label": ariaLabel,
    editorId: editorId,
    onChange: onChange,
    value: value,
    uiPlugins: uiPlugins,
    parsingPluginList: parsingPlugins,
    processingPluginList: processingPlugins,
    onParse: onParse,
    errors: markdownErrorMessages,
    "data-test-subj": dataTestSubj,
    height: height
  });
});
MarkdownEditorComponent.displayName = 'MarkdownEditor';
const MarkdownEditor = /*#__PURE__*/(0, _react.memo)(MarkdownEditorComponent);
exports.MarkdownEditor = MarkdownEditor;