"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FileDeleteButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_delete_file_attachment = require("../../containers/use_delete_file_attachment");
var _use_delete_property_action = require("../user_actions/property_actions/use_delete_property_action");
var _delete_attachment_confirmation_modal = require("../user_actions/delete_attachment_confirmation_modal");
var _use_cases_context = require("../cases_context/use_cases_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FileDeleteButtonComponent = ({
  caseId,
  fileId,
  isIcon
}) => {
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const {
    isLoading,
    mutate: deleteFileAttachment
  } = (0, _use_delete_file_attachment.useDeleteFileAttachment)();
  const {
    showDeletionModal,
    onModalOpen,
    onConfirm,
    onCancel
  } = (0, _use_delete_property_action.useDeletePropertyAction)({
    onDelete: () => deleteFileAttachment({
      caseId,
      fileId
    })
  });
  const buttonProps = {
    iconType: 'trash',
    'aria-label': i18n.DELETE_FILE,
    color: 'danger',
    isDisabled: isLoading,
    onClick: onModalOpen,
    'data-test-subj': 'cases-files-delete-button'
  };
  return permissions.delete ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isIcon ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, buttonProps) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, buttonProps, i18n.DELETE_FILE), showDeletionModal ? /*#__PURE__*/_react.default.createElement(_delete_attachment_confirmation_modal.DeleteAttachmentConfirmationModal, {
    title: i18n.DELETE_FILE_TITLE,
    confirmButtonText: i18n.DELETE,
    onCancel: onCancel,
    onConfirm: onConfirm
  }) : null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
};
FileDeleteButtonComponent.displayName = 'FileDeleteButton';
const FileDeleteButton = /*#__PURE__*/_react.default.memo(FileDeleteButtonComponent);
exports.FileDeleteButton = FileDeleteButton;