"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.schema = void 0;
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _constants = require("../../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  emptyField,
  maxLengthField
} = _helpers.fieldValidators;
const schema = {
  key: {
    validations: [{
      validator: emptyField(i18n.REQUIRED_FIELD(i18n.FIELD_LABEL))
    }]
  },
  label: {
    label: i18n.FIELD_LABEL,
    validations: [{
      validator: emptyField(i18n.REQUIRED_FIELD(i18n.FIELD_LABEL))
    }, {
      validator: maxLengthField({
        length: _constants.MAX_CUSTOM_FIELD_LABEL_LENGTH,
        message: i18n.MAX_LENGTH_ERROR('field label', _constants.MAX_CUSTOM_FIELD_LABEL_LENGTH)
      })
    }]
  },
  type: {
    label: i18n.FIELD_TYPE,
    validations: [{
      validator: emptyField(i18n.REQUIRED_FIELD(i18n.FIELD_LABEL))
    }]
  }
};
exports.schema = schema;