"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _domain = require("../../../common/types/domain");
var _builder = require("./builder");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fieldTypeSelectOptions = () => {
  const options = [];
  for (const [id, builder] of Object.entries(_builder.builderMap)) {
    const createdBuilder = builder();
    options.push({
      value: id,
      text: createdBuilder.label
    });
  }
  return options;
};
const FormFieldsComponent = ({
  isSubmitting,
  isEditMode
}) => {
  const [selectedType, setSelectedType] = (0, _react.useState)(_domain.CustomFieldTypes.TEXT);
  const handleTypeChange = (0, _react.useCallback)(e => {
    setSelectedType(e.target.value);
  }, [setSelectedType]);
  const builtCustomField = (0, _react.useMemo)(() => {
    const builder = _builder.builderMap[selectedType];
    if (builder == null) {
      return null;
    }
    const customFieldBuilder = builder();
    return customFieldBuilder.build();
  }, [selectedType]);
  const Configure = builtCustomField === null || builtCustomField === void 0 ? void 0 : builtCustomField.Configure;
  const options = fieldTypeSelectOptions();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "key",
    component: _components.HiddenField
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "label",
    component: _components.TextField,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'custom-field-label-input',
        fullWidth: true,
        autoFocus: true,
        isLoading: isSubmitting
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    component: _components.SelectField,
    path: "type",
    componentProps: {
      euiFieldProps: {
        options,
        'data-test-subj': 'custom-field-type-selector',
        isLoading: isSubmitting,
        disabled: isEditMode
      },
      onChange: handleTypeChange
    }
  }), Configure ? /*#__PURE__*/_react.default.createElement(Configure, null) : null);
};
FormFieldsComponent.displayName = 'FormFields';
const FormFields = /*#__PURE__*/(0, _react.memo)(FormFieldsComponent);
exports.FormFields = FormFields;