"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Severity = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _domain = require("../../../common/types/domain");
var _selector = require("../severity/selector");
var _translations = require("../severity/translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SeverityFieldFormComponent = ({
  isLoading
}) => {
  const {
    setFieldValue
  } = (0, _hook_form_lib.useFormContext)();
  const [{
    severity
  }] = (0, _hook_form_lib.useFormData)({
    watch: ['severity']
  });
  const onSeverityChange = newSeverity => {
    setFieldValue('severity', newSeverity);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "caseSeverity",
    fullWidth: true,
    label: _translations.SEVERITY_TITLE
  }, /*#__PURE__*/_react.default.createElement(_selector.SeveritySelector, {
    isLoading: isLoading,
    isDisabled: isLoading,
    selectedSeverity: severity !== null && severity !== void 0 ? severity : _domain.CaseSeverity.LOW,
    onSeverityChange: onSeverityChange
  }));
};
SeverityFieldFormComponent.displayName = 'SeverityFieldForm';
const SeverityComponent = ({
  isLoading
}) => /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
  path: 'severity',
  component: SeverityFieldFormComponent,
  componentProps: {
    isLoading
  }
});
SeverityComponent.displayName = 'SeverityComponent';
const Severity = /*#__PURE__*/(0, _react.memo)(SeverityComponent);
exports.Severity = Severity;