"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
var _domain = require("../../../../common/types/domain");
var _kibana = require("../../../common/lib/kibana");
var _use_get_issue_types = require("./use_get_issue_types");
var _card = require("../card");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JiraFieldsPreviewComponent = ({
  fields,
  connector
}) => {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const {
    issueType = null,
    priority = null,
    parent = null
  } = fields !== null && fields !== void 0 ? fields : {};
  const {
    isLoading,
    isFetching,
    data: issueTypesData
  } = (0, _use_get_issue_types.useGetIssueTypes)({
    connector,
    http
  });
  const issueTypes = issueTypesData === null || issueTypesData === void 0 ? void 0 : issueTypesData.data;
  const listItems = (0, _react.useMemo)(() => {
    var _find$name, _find;
    return [...(issueType != null && issueType.length > 0 ? [{
      title: i18n.ISSUE_TYPE,
      description: (_find$name = (_find = (issueTypes !== null && issueTypes !== void 0 ? issueTypes : []).find(issue => issue.id === issueType)) === null || _find === void 0 ? void 0 : _find.name) !== null && _find$name !== void 0 ? _find$name : ''
    }] : []), ...(parent != null && parent.length > 0 ? [{
      title: i18n.PARENT_ISSUE,
      description: parent
    }] : []), ...(priority != null && priority.length > 0 ? [{
      title: i18n.PRIORITY,
      description: priority
    }] : [])];
  }, [issueType, issueTypes, parent, priority]);
  return /*#__PURE__*/_react.default.createElement(_card.ConnectorCard, {
    connectorType: _domain.ConnectorTypes.jira,
    isLoading: isLoading || isFetching,
    listItems: listItems,
    title: connector.name
  });
};
exports.default = JiraFieldsPreviewComponent;
JiraFieldsPreviewComponent.displayName = 'JiraFieldsPreview';

// eslint-disable-next-line import/no-default-export
module.exports = exports.default;