"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Mapping = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _domain = require("../../../common/types/domain");
var i18n = _interopRequireWildcard(require("./translations"));
var _field_mapping = require("./field_mapping");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MappingComponent = ({
  actionTypeName,
  connectorType,
  isLoading,
  mappings
}) => {
  const fieldMappingDesc = (0, _react.useMemo)(() => mappings.length > 0 || isLoading ? {
    desc: i18n.FIELD_MAPPING_DESC(actionTypeName),
    color: 'subdued'
  } : connectorType === _domain.ConnectorTypes.casesWebhook ? {
    desc: i18n.CASES_WEBHOOK_MAPPINGS,
    color: 'subdued'
  } : {
    desc: i18n.FIELD_MAPPING_DESC_ERR(actionTypeName),
    color: 'danger'
  }, [mappings.length, isLoading, actionTypeName, connectorType]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    "data-test-subj": "field-mapping-text"
  }, /*#__PURE__*/_react.default.createElement("h4", null, i18n.FIELD_MAPPING_TITLE(actionTypeName)), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    "data-test-subj": "field-mapping-desc",
    color: fieldMappingDesc.color
  }, fieldMappingDesc.desc))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_field_mapping.FieldMapping, {
    actionTypeName: actionTypeName,
    "data-test-subj": "case-mappings-field",
    isLoading: isLoading,
    mappings: mappings
  })));
};
MappingComponent.displayName = 'Mapping';
const Mapping = /*#__PURE__*/_react.default.memo(MappingComponent);
exports.Mapping = Mapping;