"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRegistrationContextFromIndex = exports.getRegistrationContextFromAlerts = exports.getManualAlertIds = void 0;
var _domain = require("../../../../common/types/domain");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getManualAlertIds = comments => {
  const dedupeAlerts = comments.reduce((alertIds, comment) => {
    if (comment.type === _domain.AttachmentType.alert) {
      const ids = Array.isArray(comment.alertId) ? comment.alertId : [comment.alertId];
      ids.forEach(id => alertIds.add(id));
      return alertIds;
    }
    return alertIds;
  }, new Set());
  return Array.from(dedupeAlerts);
};
exports.getManualAlertIds = getManualAlertIds;
const getRegistrationContextFromAlerts = comments => {
  const dedupeRegistrationContext = comments.reduce((registrationContexts, comment) => {
    if (comment.type === _domain.AttachmentType.alert) {
      const indices = Array.isArray(comment.index) ? comment.index : [comment.index];
      indices.forEach(index => {
        // That's legacy code, we created some index alias so everything should work as expected
        if (index.startsWith('.siem-signals')) {
          registrationContexts.add('security');
        } else {
          const registrationContext = getRegistrationContextFromIndex(index);
          if (registrationContext) {
            registrationContexts.add(registrationContext);
          }
        }
      });
      return registrationContexts;
    }
    return registrationContexts;
  }, new Set());
  return Array.from(dedupeRegistrationContext);
};
exports.getRegistrationContextFromAlerts = getRegistrationContextFromAlerts;
const getRegistrationContextFromIndex = indexName => {
  const found = indexName.match(/\.alerts-(.*?).alerts/);
  if (found && found.length > 1) {
    return `${found[1]}`;
  }
  return null;
};
exports.getRegistrationContextFromIndex = getRegistrationContextFromIndex;