"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _use_cases_context = require("../../cases_context/use_cases_context");
var _builder = require("../../custom_fields/builder");
var _utils = require("../../custom_fields/utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CustomFieldsComponent = ({
  isLoading,
  customFields,
  customFieldsConfiguration,
  onSubmit
}) => {
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const sortedCustomFieldsConfiguration = (0, _react.useMemo)(() => sortCustomFieldsByLabel(customFieldsConfiguration), [customFieldsConfiguration]);
  const onSubmitCustomField = (0, _react.useCallback)(customFieldToAdd => {
    const allCustomFields = createMissingAndRemoveExtraCustomFields(customFields, customFieldsConfiguration);
    const updatedCustomFields = (0, _utils.addOrReplaceCustomField)(allCustomFields, customFieldToAdd);
    onSubmit(updatedCustomFields);
  }, [customFields, customFieldsConfiguration, onSubmit]);
  const customFieldsComponents = sortedCustomFieldsConfiguration.map(customFieldConf => {
    const customFieldFactory = _builder.builderMap[customFieldConf.type];
    const customFieldType = customFieldFactory().build();
    const customField = customFields.find(field => field.key === customFieldConf.key);
    const EditComponent = customFieldType.Edit;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      "data-test-subj": `case-custom-field-wrapper-${customFieldConf.key}`,
      key: customFieldConf.key
    }, /*#__PURE__*/_react.default.createElement(EditComponent, {
      isLoading: isLoading,
      canUpdate: permissions.update,
      customFieldConfiguration: customFieldConf,
      customField: customField,
      onSubmit: onSubmitCustomField
    }));
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, customFieldsComponents);
};
CustomFieldsComponent.displayName = 'CustomFields';
const CustomFields = /*#__PURE__*/_react.default.memo(CustomFieldsComponent);
exports.CustomFields = CustomFields;
const sortCustomFieldsByLabel = customFieldsConfiguration => {
  return (0, _lodash.sortBy)(customFieldsConfiguration, customFieldConf => {
    return customFieldConf.label;
  });
};
const createMissingAndRemoveExtraCustomFields = (customFields, confCustomFields) => {
  const createdCustomFields = confCustomFields.map(confCustomField => {
    const foundCustomField = customFields.find(customField => customField.key === confCustomField.key);
    if (foundCustomField) {
      return foundCustomField;
    }
    return {
      key: confCustomField.key,
      type: confCustomField.type,
      value: null
    };
  });
  return createdCustomFields;
};